/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.integration.deda.recipes;

import com.brandon3055.draconicevolution.DEFeatures;
import com.github.gtexpert.core.api.GTEValues;
import com.github.gtexpert.core.api.unification.material.GTEMaterials;
import com.github.gtexpert.core.api.util.GTEUtility;
import com.github.gtexpert.core.api.util.Mods;
import com.github.gtexpert.core.integration.deda.recipemaps.GTEDraconicRecipeMaps;
import com.github.gtexpert.core.integration.deda.recipemaps.tierup.TierUpRecipeBuilder;
import gregicality.multiblocks.api.fluids.GCYMFluidStorageKeys;
import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.api.recipes.ingredients.nbtmatch.NBTTagType;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.items.MetaItems;
import gregtech.common.items.ToolItems;
import net.foxmcloud.draconicadditions.DAFeatures;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class DraconicTierupRecipe {
    public static void init() {
        ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("wyvern_axe"));
        DraconicTierupRecipe.addTierUpRecipe(new GTRecipeItemInput(ToolItems.AXE.get(GTEMaterials.Draconium)).setNBTMatchingCondition(NBTMatcher.RECURSIVE_EQUAL_TO, NBTCondition.create((NBTTagType)NBTTagType.COMPOUND, (String)"GT.Tool", (Object)NBTCondition.create((NBTTagType)NBTTagType.STRING, (String)"Material", (Object)"gtexpert:draconium"))), new ItemStack((Item)DEFeatures.wyvernAxe), Tier.WYVERN, 2);
        ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("wyvern_pick"));
        DraconicTierupRecipe.addTierUpRecipe(new GTRecipeItemInput(ToolItems.PICKAXE.get(GTEMaterials.Draconium)).setNBTMatchingCondition(NBTMatcher.RECURSIVE_EQUAL_TO, NBTCondition.create((NBTTagType)NBTTagType.COMPOUND, (String)"GT.Tool", (Object)NBTCondition.create((NBTTagType)NBTTagType.STRING, (String)"Material", (Object)"gtexpert:draconium"))), new ItemStack((Item)DEFeatures.wyvernPick), Tier.WYVERN, 2);
        ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("wyvern_shovel"));
        DraconicTierupRecipe.addTierUpRecipe(new GTRecipeItemInput(ToolItems.SHOVEL.get(GTEMaterials.Draconium)).setNBTMatchingCondition(NBTMatcher.RECURSIVE_EQUAL_TO, NBTCondition.create((NBTTagType)NBTTagType.COMPOUND, (String)"GT.Tool", (Object)NBTCondition.create((NBTTagType)NBTTagType.STRING, (String)"Material", (Object)"gtexpert:draconium"))), new ItemStack((Item)DEFeatures.wyvernShovel), Tier.WYVERN, 2);
        ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("wyvern_sword"));
        DraconicTierupRecipe.addTierUpRecipe(MetaItems.NANO_SABER.getStackForm(), new ItemStack((Item)DEFeatures.wyvernSword), Tier.WYVERN, 2);
        ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("wyvern_bow"));
        DraconicTierupRecipe.addTierUpRecipe(new GTRecipeItemInput(Mods.EnderIO.isModLoaded() ? GTEUtility.getModItem("enderio", "item_dark_steel_bow") : Mods.Vanilla.getItem("bow")).setNBTMatchingCondition(NBTMatcher.ANY, NBTCondition.ANY), new ItemStack((Item)DEFeatures.wyvernBow), Tier.WYVERN, 2);
        ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("wyvern_helm"));
        DraconicTierupRecipe.addTierUpRecipe(MetaItems.QUANTUM_HELMET.getStackForm(), new ItemStack((Item)DEFeatures.wyvernHelm), Tier.WYVERN, 6);
        ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("wyvern_chest"));
        DraconicTierupRecipe.addTierUpRecipe(MetaItems.QUANTUM_CHESTPLATE_ADVANCED.getStackForm(), new ItemStack((Item)DEFeatures.wyvernChest), Tier.WYVERN, 6);
        ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("wyvern_legs"));
        DraconicTierupRecipe.addTierUpRecipe(MetaItems.QUANTUM_LEGGINGS.getStackForm(), new ItemStack((Item)DEFeatures.wyvernLegs), Tier.WYVERN, 6);
        ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("wyvern_boots"));
        DraconicTierupRecipe.addTierUpRecipe(MetaItems.QUANTUM_BOOTS.getStackForm(), new ItemStack((Item)DEFeatures.wyvernBoots), Tier.WYVERN, 6);
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.wyvernAxe), new ItemStack((Item)DEFeatures.draconicAxe), Tier.DRACONIC);
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.wyvernPick), new ItemStack((Item)DEFeatures.draconicPick), Tier.DRACONIC);
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.wyvernShovel), new ItemStack((Item)DEFeatures.draconicShovel), Tier.DRACONIC);
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.wyvernSword), new ItemStack((Item)DEFeatures.draconicSword), Tier.DRACONIC);
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.wyvernBow), new ItemStack((Item)DEFeatures.draconicBow), Tier.DRACONIC);
        ((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)GTEDraconicRecipeMaps.DRACONIC_FUSION_TIER_UP_FAKE_RECIPES.recipeBuilder()).catalyst(new GTRecipeItemInput(new ItemStack((Item)DEFeatures.draconicPick)).setNBTMatchingCondition(NBTMatcher.ANY, NBTCondition.ANY)).result(new ItemStack((Item)DEFeatures.draconicStaffOfPower)).input(OrePrefix.plate, GTEMaterials.Draconium, 6)).inputNBT((Item)DEFeatures.draconicAxe, NBTMatcher.ANY, NBTCondition.ANY)).inputNBT((Item)DEFeatures.draconicShovel, NBTMatcher.ANY, NBTCondition.ANY)).inputNBT((Item)DEFeatures.draconicSword, NBTMatcher.ANY, NBTCondition.ANY)).input((Item)DEFeatures.draconicCore, 4)).fluidInputs(new FluidStack[]{GTEMaterials.Cryotheum.getFluid(32000)})).fluidOutputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 8000)})).duration(400)).EUt(GTValues.VA[GTEValues.dedaVoltageTier + 1])).buildAndRegister();
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.wyvernHelm), new ItemStack((Item)DEFeatures.draconicHelm), Tier.DRACONIC);
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.wyvernChest), new ItemStack((Item)DEFeatures.draconicChest), Tier.DRACONIC);
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.wyvernLegs), new ItemStack((Item)DEFeatures.draconicLegs), Tier.DRACONIC);
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.wyvernBoots), new ItemStack((Item)DEFeatures.draconicBoots), Tier.DRACONIC);
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.draconicStaffOfPower), new ItemStack((Item)DAFeatures.chaoticStaffOfPower), Tier.CHAOTIC);
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.draconicBow), new ItemStack((Item)DAFeatures.chaoticBow), Tier.CHAOTIC);
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.draconicHelm), new ItemStack((Item)DAFeatures.chaoticHelm), Tier.CHAOTIC);
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.draconicChest), new ItemStack((Item)DAFeatures.chaoticChest), Tier.CHAOTIC);
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.draconicLegs), new ItemStack((Item)DAFeatures.chaoticLegs), Tier.CHAOTIC);
        DraconicTierupRecipe.addTierUpRecipe(new ItemStack((Item)DEFeatures.draconicBoots), new ItemStack((Item)DAFeatures.chaoticBoots), Tier.CHAOTIC);
    }

    private static void addTierUpRecipe(ItemStack catalyst, ItemStack result, Tier tier) {
        DraconicTierupRecipe.addTierUpRecipe(catalyst, result, tier, -1);
    }

    private static void addTierUpRecipe(GTRecipeInput catalyst, ItemStack result, Tier tier) {
        DraconicTierupRecipe.addTierUpRecipe(catalyst, result, tier, -1);
    }

    private static void addTierUpRecipe(ItemStack catalyst, ItemStack result, Tier tier, int plateAmount) {
        DraconicTierupRecipe.addTierUpRecipe(new GTRecipeItemInput(catalyst).setNBTMatchingCondition(NBTMatcher.ANY, NBTCondition.ANY), result, tier, plateAmount);
    }

    private static void addTierUpRecipe(GTRecipeInput catalyst, ItemStack result, Tier tier, int plateAmount) {
        RecipeMap<TierUpRecipeBuilder> recipeMap = tier == Tier.CHAOTIC ? GTEDraconicRecipeMaps.AWAKENED_DRACONIC_FUSION_TIER_UP_FAKE_RECIPES : GTEDraconicRecipeMaps.DRACONIC_FUSION_TIER_UP_FAKE_RECIPES;
        TierUpRecipeBuilder recipeBuilder = (TierUpRecipeBuilder)recipeMap.recipeBuilder();
        recipeBuilder.catalyst(catalyst).result(result);
        switch (tier) {
            case WYVERN: {
                ((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)recipeBuilder.input(OrePrefix.plate, GTEMaterials.Draconium, plateAmount)).input((Item)DEFeatures.wyvernCore, 1)).input(DEFeatures.wyvernEnergyCore, 1)).fluidInputs(new FluidStack[]{GTEMaterials.Cryotheum.getFluid(16000)})).fluidOutputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 4000)})).duration(200)).EUt(GTValues.VA[GTEValues.dedaVoltageTier]);
                break;
            }
            case DRACONIC: {
                ((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)recipeBuilder.input(OrePrefix.plate, GTEMaterials.AwakenedDraconium, 2)).input((Item)DEFeatures.draconicCore, 4)).input(DEFeatures.draconicEnergyCore, 1)).fluidInputs(new FluidStack[]{GTEMaterials.Cryotheum.getFluid(32000)})).fluidOutputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 8000)})).duration(400)).EUt(GTValues.VA[GTEValues.dedaVoltageTier + 1]);
                break;
            }
            case CHAOTIC: {
                ((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)((TierUpRecipeBuilder)recipeBuilder.input((Item)DEFeatures.chaosShard, 4, 0)).input((Block)DEFeatures.infusedObsidian, 2)).input((Item)DEFeatures.chaoticCore, 1)).input((Item)DAFeatures.chaoticEnergyCore, 1)).fluidInputs(new FluidStack[]{GTEMaterials.Cryotheum.getFluid(48000)})).fluidOutputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 12000)})).duration(600)).EUt(GTValues.VA[GTEValues.dedaVoltageTier + 2]);
            }
        }
        recipeBuilder.buildAndRegister();
    }

    private static enum Tier {
        WYVERN,
        DRACONIC,
        CHAOTIC;

    }
}

