/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.api.util;

import com.github.gtexpert.core.common.items.GTEMetaItems;
import gregtech.api.GTValues;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.stack.ItemMaterialInfo;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.common.items.MetaItems;
import java.util.Objects;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class GTEUtility {
    @NotNull
    public static ItemStack getModItem(String modID, String itemName) {
        return GameRegistry.makeItemStack((String)(modID + ":" + itemName), (int)0, (int)1, null);
    }

    @NotNull
    public static ItemStack getModItem(String modID, String itemName, int amount) {
        return GameRegistry.makeItemStack((String)(modID + ":" + itemName), (int)0, (int)amount, null);
    }

    @NotNull
    public static ItemStack getModItem(String modID, String itemName, int amount, int meta) {
        return GameRegistry.makeItemStack((String)(modID + ":" + itemName), (int)meta, (int)amount, null);
    }

    @NotNull
    public static ItemStack getModItem(String modID, String itemName, int amount, int meta, NBTTagCompound nbt) {
        return GameRegistry.makeItemStack((String)(modID + ":" + itemName), (int)meta, (int)amount, (String)(nbt != null ? nbt.toString() : null));
    }

    @NotNull
    public static FluidStack getModFluid(String fluidName) {
        return Objects.requireNonNull(FluidRegistry.getFluidStack((String)fluidName, (int)1000));
    }

    @NotNull
    public static FluidStack getModFluid(String fluidName, int amount) {
        return Objects.requireNonNull(FluidRegistry.getFluidStack((String)fluidName, (int)amount));
    }

    @NotNull
    public static ResourceLocation gteId(String path) {
        return new ResourceLocation("gtexpert", path);
    }

    public static void registerOre(String dictName, ItemStack ... itemStacks) {
        for (ItemStack stack : itemStacks) {
            OreDictionary.registerOre((String)dictName, (ItemStack)stack);
        }
    }

    public static String generateRandomString(int length) {
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(random.nextInt(10));
        }
        return stringBuilder.toString();
    }

    public static MetaItem.MetaValueItem motor(int voltage) {
        MetaItem.MetaValueItem metaValueItem;
        switch (voltage) {
            case 0: {
                metaValueItem = GTEMetaItems.GTE_ELECTRIC_MOTOR;
                break;
            }
            case 1: {
                metaValueItem = MetaItems.ELECTRIC_MOTOR_LV;
                break;
            }
            case 2: {
                metaValueItem = MetaItems.ELECTRIC_MOTOR_MV;
                break;
            }
            case 3: {
                metaValueItem = MetaItems.ELECTRIC_MOTOR_HV;
                break;
            }
            case 4: {
                metaValueItem = MetaItems.ELECTRIC_MOTOR_EV;
                break;
            }
            case 5: {
                metaValueItem = MetaItems.ELECTRIC_MOTOR_IV;
                break;
            }
            case 6: {
                metaValueItem = MetaItems.ELECTRIC_MOTOR_LuV;
                break;
            }
            case 7: {
                metaValueItem = MetaItems.ELECTRIC_MOTOR_ZPM;
                break;
            }
            case 8: {
                metaValueItem = MetaItems.ELECTRIC_MOTOR_UV;
                break;
            }
            case 9: {
                metaValueItem = MetaItems.ELECTRIC_MOTOR_UHV;
                break;
            }
            case 10: {
                metaValueItem = MetaItems.ELECTRIC_MOTOR_UEV;
                break;
            }
            case 11: {
                metaValueItem = MetaItems.ELECTRIC_MOTOR_UIV;
                break;
            }
            case 12: {
                metaValueItem = MetaItems.ELECTRIC_MOTOR_UXV;
                break;
            }
            case 13: {
                metaValueItem = MetaItems.ELECTRIC_MOTOR_OpV;
                break;
            }
            default: {
                throw new IllegalStateException("Out of Voltage: " + GTValues.VN[voltage]);
            }
        }
        return metaValueItem;
    }

    public static MetaItem.MetaValueItem pump(int voltage) {
        MetaItem.MetaValueItem metaValueItem;
        switch (voltage) {
            case 0: {
                metaValueItem = GTEMetaItems.GTE_ELECTRIC_PUMP;
                break;
            }
            case 1: {
                metaValueItem = MetaItems.ELECTRIC_PUMP_LV;
                break;
            }
            case 2: {
                metaValueItem = MetaItems.ELECTRIC_PUMP_MV;
                break;
            }
            case 3: {
                metaValueItem = MetaItems.ELECTRIC_PUMP_HV;
                break;
            }
            case 4: {
                metaValueItem = MetaItems.ELECTRIC_PUMP_EV;
                break;
            }
            case 5: {
                metaValueItem = MetaItems.ELECTRIC_PUMP_IV;
                break;
            }
            case 6: {
                metaValueItem = MetaItems.ELECTRIC_PUMP_LuV;
                break;
            }
            case 7: {
                metaValueItem = MetaItems.ELECTRIC_PUMP_ZPM;
                break;
            }
            case 8: {
                metaValueItem = MetaItems.ELECTRIC_PUMP_UV;
                break;
            }
            case 9: {
                metaValueItem = MetaItems.ELECTRIC_PUMP_UHV;
                break;
            }
            case 10: {
                metaValueItem = MetaItems.ELECTRIC_PUMP_UEV;
                break;
            }
            case 11: {
                metaValueItem = MetaItems.ELECTRIC_PUMP_UIV;
                break;
            }
            case 12: {
                metaValueItem = MetaItems.ELECTRIC_PUMP_UXV;
                break;
            }
            case 13: {
                metaValueItem = MetaItems.ELECTRIC_PUMP_OpV;
                break;
            }
            default: {
                throw new IllegalStateException("Out of Voltage: " + GTValues.VN[voltage]);
            }
        }
        return metaValueItem;
    }

    public static MetaItem.MetaValueItem regulator(int voltage) {
        MetaItem.MetaValueItem metaValueItem;
        switch (voltage) {
            case 0: {
                metaValueItem = GTEMetaItems.GTE_FLUID_REGULATOR;
                break;
            }
            case 1: {
                metaValueItem = MetaItems.FLUID_REGULATOR_LV;
                break;
            }
            case 2: {
                metaValueItem = MetaItems.FLUID_REGULATOR_MV;
                break;
            }
            case 3: {
                metaValueItem = MetaItems.FLUID_REGULATOR_HV;
                break;
            }
            case 4: {
                metaValueItem = MetaItems.FLUID_REGULATOR_EV;
                break;
            }
            case 5: {
                metaValueItem = MetaItems.FLUID_REGULATOR_IV;
                break;
            }
            case 6: {
                metaValueItem = MetaItems.FLUID_REGULATOR_LUV;
                break;
            }
            case 7: {
                metaValueItem = MetaItems.FLUID_REGULATOR_ZPM;
                break;
            }
            case 8: {
                metaValueItem = MetaItems.FLUID_REGULATOR_UV;
                break;
            }
            default: {
                throw new IllegalStateException("Out of Voltage: " + GTValues.VN[voltage]);
            }
        }
        return metaValueItem;
    }

    public static MetaItem.MetaValueItem piston(int voltage) {
        MetaItem.MetaValueItem metaValueItem;
        switch (voltage) {
            case 0: {
                metaValueItem = GTEMetaItems.GTE_ELECTRIC_PISTON;
                break;
            }
            case 1: {
                metaValueItem = MetaItems.ELECTRIC_PISTON_LV;
                break;
            }
            case 2: {
                metaValueItem = MetaItems.ELECTRIC_PISTON_MV;
                break;
            }
            case 3: {
                metaValueItem = MetaItems.ELECTRIC_PISTON_HV;
                break;
            }
            case 4: {
                metaValueItem = MetaItems.ELECTRIC_PISTON_EV;
                break;
            }
            case 5: {
                metaValueItem = MetaItems.ELECTRIC_PISTON_IV;
                break;
            }
            case 6: {
                metaValueItem = MetaItems.ELECTRIC_PISTON_LUV;
                break;
            }
            case 7: {
                metaValueItem = MetaItems.ELECTRIC_PISTON_ZPM;
                break;
            }
            case 8: {
                metaValueItem = MetaItems.ELECTRIC_PISTON_UV;
                break;
            }
            case 9: {
                metaValueItem = MetaItems.ELECTRIC_PISTON_UHV;
                break;
            }
            case 10: {
                metaValueItem = MetaItems.ELECTRIC_PISTON_UEV;
                break;
            }
            case 11: {
                metaValueItem = MetaItems.ELECTRIC_PISTON_UIV;
                break;
            }
            case 12: {
                metaValueItem = MetaItems.ELECTRIC_PISTON_UXV;
                break;
            }
            case 13: {
                metaValueItem = MetaItems.ELECTRIC_PISTON_OpV;
                break;
            }
            default: {
                throw new IllegalStateException("Out of Voltage: " + GTValues.VN[voltage]);
            }
        }
        return metaValueItem;
    }

    public static MetaItem.MetaValueItem robotArm(int voltage) {
        MetaItem.MetaValueItem metaValueItem;
        switch (voltage) {
            case 0: {
                metaValueItem = GTEMetaItems.GTE_ROBOT_ARM;
                break;
            }
            case 1: {
                metaValueItem = MetaItems.ROBOT_ARM_LV;
                break;
            }
            case 2: {
                metaValueItem = MetaItems.ROBOT_ARM_MV;
                break;
            }
            case 3: {
                metaValueItem = MetaItems.ROBOT_ARM_HV;
                break;
            }
            case 4: {
                metaValueItem = MetaItems.ROBOT_ARM_EV;
                break;
            }
            case 5: {
                metaValueItem = MetaItems.ROBOT_ARM_IV;
                break;
            }
            case 6: {
                metaValueItem = MetaItems.ROBOT_ARM_LuV;
                break;
            }
            case 7: {
                metaValueItem = MetaItems.ROBOT_ARM_ZPM;
                break;
            }
            case 8: {
                metaValueItem = MetaItems.ROBOT_ARM_UV;
                break;
            }
            case 9: {
                metaValueItem = MetaItems.ROBOT_ARM_UHV;
                break;
            }
            case 10: {
                metaValueItem = MetaItems.ROBOT_ARM_UEV;
                break;
            }
            case 11: {
                metaValueItem = MetaItems.ROBOT_ARM_UIV;
                break;
            }
            case 12: {
                metaValueItem = MetaItems.ROBOT_ARM_UXV;
                break;
            }
            case 13: {
                metaValueItem = MetaItems.ROBOT_ARM_OpV;
                break;
            }
            default: {
                throw new IllegalStateException("Out of Voltage: " + GTValues.VN[voltage]);
            }
        }
        return metaValueItem;
    }

    public static MetaItem.MetaValueItem fieldGenerator(int voltage) {
        MetaItem.MetaValueItem metaValueItem;
        switch (voltage) {
            case 0: {
                metaValueItem = GTEMetaItems.GTE_FIELD_GENERATOR;
                break;
            }
            case 1: {
                metaValueItem = MetaItems.FIELD_GENERATOR_LV;
                break;
            }
            case 2: {
                metaValueItem = MetaItems.FIELD_GENERATOR_MV;
                break;
            }
            case 3: {
                metaValueItem = MetaItems.FIELD_GENERATOR_HV;
                break;
            }
            case 4: {
                metaValueItem = MetaItems.FIELD_GENERATOR_EV;
                break;
            }
            case 5: {
                metaValueItem = MetaItems.FIELD_GENERATOR_IV;
                break;
            }
            case 6: {
                metaValueItem = MetaItems.FIELD_GENERATOR_LuV;
                break;
            }
            case 7: {
                metaValueItem = MetaItems.FIELD_GENERATOR_ZPM;
                break;
            }
            case 8: {
                metaValueItem = MetaItems.FIELD_GENERATOR_UV;
                break;
            }
            case 9: {
                metaValueItem = MetaItems.FIELD_GENERATOR_UHV;
                break;
            }
            case 10: {
                metaValueItem = MetaItems.FIELD_GENERATOR_UEV;
                break;
            }
            case 11: {
                metaValueItem = MetaItems.FIELD_GENERATOR_UIV;
                break;
            }
            case 12: {
                metaValueItem = MetaItems.FIELD_GENERATOR_UXV;
                break;
            }
            case 13: {
                metaValueItem = MetaItems.FIELD_GENERATOR_OpV;
                break;
            }
            default: {
                throw new IllegalStateException("Out of Voltage: " + GTValues.VN[voltage]);
            }
        }
        return metaValueItem;
    }

    public static MetaItem.MetaValueItem conveyorModule(int voltage) {
        MetaItem.MetaValueItem metaValueItem;
        switch (voltage) {
            case 0: {
                metaValueItem = GTEMetaItems.GTE_CONVEYOR_MODULE;
                break;
            }
            case 1: {
                metaValueItem = MetaItems.CONVEYOR_MODULE_LV;
                break;
            }
            case 2: {
                metaValueItem = MetaItems.CONVEYOR_MODULE_MV;
                break;
            }
            case 3: {
                metaValueItem = MetaItems.CONVEYOR_MODULE_HV;
                break;
            }
            case 4: {
                metaValueItem = MetaItems.CONVEYOR_MODULE_EV;
                break;
            }
            case 5: {
                metaValueItem = MetaItems.CONVEYOR_MODULE_IV;
                break;
            }
            case 6: {
                metaValueItem = MetaItems.CONVEYOR_MODULE_LuV;
                break;
            }
            case 7: {
                metaValueItem = MetaItems.CONVEYOR_MODULE_ZPM;
                break;
            }
            case 8: {
                metaValueItem = MetaItems.CONVEYOR_MODULE_UV;
                break;
            }
            case 9: {
                metaValueItem = MetaItems.CONVEYOR_MODULE_UHV;
                break;
            }
            case 10: {
                metaValueItem = MetaItems.CONVEYOR_MODULE_UEV;
                break;
            }
            case 11: {
                metaValueItem = MetaItems.CONVEYOR_MODULE_UIV;
                break;
            }
            case 12: {
                metaValueItem = MetaItems.CONVEYOR_MODULE_UXV;
                break;
            }
            case 13: {
                metaValueItem = MetaItems.CONVEYOR_MODULE_OpV;
                break;
            }
            default: {
                throw new IllegalStateException("Out of Voltage: " + GTValues.VN[voltage]);
            }
        }
        return metaValueItem;
    }

    public static MetaItem.MetaValueItem emitter(int voltage) {
        MetaItem.MetaValueItem metaValueItem;
        switch (voltage) {
            case 0: {
                metaValueItem = GTEMetaItems.GTE_EMITTER;
                break;
            }
            case 1: {
                metaValueItem = MetaItems.EMITTER_LV;
                break;
            }
            case 2: {
                metaValueItem = MetaItems.EMITTER_MV;
                break;
            }
            case 3: {
                metaValueItem = MetaItems.EMITTER_HV;
                break;
            }
            case 4: {
                metaValueItem = MetaItems.EMITTER_EV;
                break;
            }
            case 5: {
                metaValueItem = MetaItems.EMITTER_IV;
                break;
            }
            case 6: {
                metaValueItem = MetaItems.EMITTER_LuV;
                break;
            }
            case 7: {
                metaValueItem = MetaItems.EMITTER_ZPM;
                break;
            }
            case 8: {
                metaValueItem = MetaItems.EMITTER_UV;
                break;
            }
            case 9: {
                metaValueItem = MetaItems.EMITTER_UHV;
                break;
            }
            case 10: {
                metaValueItem = MetaItems.EMITTER_UEV;
                break;
            }
            case 11: {
                metaValueItem = MetaItems.EMITTER_UIV;
                break;
            }
            case 12: {
                metaValueItem = MetaItems.EMITTER_UXV;
                break;
            }
            case 13: {
                metaValueItem = MetaItems.EMITTER_OpV;
                break;
            }
            default: {
                throw new IllegalStateException("Out of Voltage: " + GTValues.VN[voltage]);
            }
        }
        return metaValueItem;
    }

    public static MetaItem.MetaValueItem sensor(int voltage) {
        MetaItem.MetaValueItem metaValueItem;
        switch (voltage) {
            case 0: {
                metaValueItem = GTEMetaItems.GTE_SENSOR;
                break;
            }
            case 1: {
                metaValueItem = MetaItems.SENSOR_LV;
                break;
            }
            case 2: {
                metaValueItem = MetaItems.SENSOR_MV;
                break;
            }
            case 3: {
                metaValueItem = MetaItems.SENSOR_HV;
                break;
            }
            case 4: {
                metaValueItem = MetaItems.SENSOR_EV;
                break;
            }
            case 5: {
                metaValueItem = MetaItems.SENSOR_IV;
                break;
            }
            case 6: {
                metaValueItem = MetaItems.SENSOR_LuV;
                break;
            }
            case 7: {
                metaValueItem = MetaItems.SENSOR_ZPM;
                break;
            }
            case 8: {
                metaValueItem = MetaItems.SENSOR_UV;
                break;
            }
            case 9: {
                metaValueItem = MetaItems.SENSOR_UHV;
                break;
            }
            case 10: {
                metaValueItem = MetaItems.SENSOR_UEV;
                break;
            }
            case 11: {
                metaValueItem = MetaItems.SENSOR_UIV;
                break;
            }
            case 12: {
                metaValueItem = MetaItems.SENSOR_UXV;
                break;
            }
            case 13: {
                metaValueItem = MetaItems.SENSOR_OpV;
                break;
            }
            default: {
                throw new IllegalStateException("Out of Voltage: " + GTValues.VN[voltage]);
            }
        }
        return metaValueItem;
    }

    public static MetaItem.MetaValueItem batteryHull(int voltage) {
        MetaItem.MetaValueItem metaValueItem;
        switch (voltage) {
            case 1: {
                metaValueItem = MetaItems.BATTERY_HULL_LV;
                break;
            }
            case 2: {
                metaValueItem = MetaItems.BATTERY_HULL_MV;
                break;
            }
            case 3: {
                metaValueItem = MetaItems.BATTERY_HULL_HV;
                break;
            }
            case 4: {
                metaValueItem = MetaItems.BATTERY_HULL_SMALL_VANADIUM;
                break;
            }
            case 5: {
                metaValueItem = MetaItems.BATTERY_HULL_MEDIUM_VANADIUM;
                break;
            }
            case 6: {
                metaValueItem = MetaItems.BATTERY_HULL_LARGE_VANADIUM;
                break;
            }
            case 7: {
                metaValueItem = MetaItems.BATTERY_HULL_MEDIUM_NAQUADRIA;
                break;
            }
            case 8: {
                metaValueItem = MetaItems.BATTERY_HULL_LARGE_NAQUADRIA;
                break;
            }
            default: {
                throw new IllegalStateException("Out of Voltage: " + GTValues.VN[voltage]);
            }
        }
        return metaValueItem;
    }

    public static MetaItem.MetaValueItem circuitBoard(int voltage) {
        MetaItem.MetaValueItem metaValueItem;
        switch (voltage) {
            case 1: {
                metaValueItem = MetaItems.BASIC_CIRCUIT_BOARD;
                break;
            }
            case 2: {
                metaValueItem = MetaItems.GOOD_CIRCUIT_BOARD;
                break;
            }
            case 3: {
                metaValueItem = MetaItems.PLASTIC_CIRCUIT_BOARD;
                break;
            }
            case 4: {
                metaValueItem = MetaItems.ADVANCED_CIRCUIT_BOARD;
                break;
            }
            case 5: {
                metaValueItem = MetaItems.EXTREME_CIRCUIT_BOARD;
                break;
            }
            case 6: {
                metaValueItem = MetaItems.ELITE_CIRCUIT_BOARD;
                break;
            }
            case 7: {
                metaValueItem = MetaItems.WETWARE_CIRCUIT_BOARD;
                break;
            }
            default: {
                throw new IllegalStateException("Out of Voltage: " + GTValues.VN[voltage]);
            }
        }
        return metaValueItem;
    }

    public static String oreDictionaryCircuit(int voltage) {
        String string;
        switch (voltage) {
            case 0: {
                string = "circuitUlv";
                break;
            }
            case 1: {
                string = "circuitLv";
                break;
            }
            case 2: {
                string = "circuitMv";
                break;
            }
            case 3: {
                string = "circuitHv";
                break;
            }
            case 4: {
                string = "circuitEv";
                break;
            }
            case 5: {
                string = "circuitIv";
                break;
            }
            case 6: {
                string = "circuitLuv";
                break;
            }
            case 7: {
                string = "circuitZpm";
                break;
            }
            case 8: {
                string = "circuitUv";
                break;
            }
            case 9: {
                string = "circuitUhv";
                break;
            }
            case 10: {
                string = "circuitUev";
                break;
            }
            case 11: {
                string = "circuitUiv";
                break;
            }
            case 12: {
                string = "circuitUxv";
                break;
            }
            case 13: {
                string = "circuitOpv";
                break;
            }
            default: {
                throw new IllegalStateException("Out of Voltage: " + GTValues.VN[voltage]);
            }
        }
        return string;
    }

    public static void registerOre(ItemStack itemStack, Material material, long amount) {
        GTEUtility.registerOre(itemStack, new MaterialStack(material, amount));
    }

    public static void registerOre(ItemStack itemStack, MaterialStack ... materialStacks) {
        GTEUtility.registerOre(itemStack, new ItemMaterialInfo(materialStacks));
    }

    public static void registerOre(ItemStack itemStack, ItemMaterialInfo materialInfo) {
        OreDictUnifier.registerOre((ItemStack)itemStack, (ItemMaterialInfo)materialInfo);
    }
}

