/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.common.metatileentities.multi;

import com.github.gtexpert.core.api.gui.GTEGuiTextures;
import gregicality.multiblocks.api.capability.impl.GCYMMultiblockRecipeLogic;
import gregicality.multiblocks.api.metatileentity.GCYMRecipeMapMultiblockController;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.logic.OverclockingLogic;
import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityAdvancedChemicalPlant
extends GCYMRecipeMapMultiblockController {
    public MetaTileEntityAdvancedChemicalPlant(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.LARGE_CHEMICAL_RECIPES);
        this.recipeMapWorkable = new AdvancedChemicalPlantWorkableHandler((RecipeMapMultiblockController)this);
    }

    @NotNull
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityAdvancedChemicalPlant(this.metaTileEntityId);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        TraceabilityPredicate casing = MetaTileEntityAdvancedChemicalPlant.states((IBlockState[])new IBlockState[]{this.getCasingState()}).setMinGlobalLimited(22);
        TraceabilityPredicate abilities = this.autoAbilities(true, true, true, true, true, true, false);
        return FactoryBlockPattern.start().aisle(new String[]{"X   X", "XXXXX", "X   X", "XXXXX", "X   X"}).aisle(new String[]{"XXXXX", "XCCCX", "XPPPX", "XCCCX", "XXXXX"}).aisle(new String[]{"X   X", "XPPPX", "XPTPX", "XPPPX", "X   X"}).aisle(new String[]{"XXXXX", "XCCCX", "XPPPX", "XCCCX", "XXXXX"}).aisle(new String[]{"X   X", "SXXXX", "X   X", "XXXXX", "X   X"}).where('S', this.selfPredicate()).where('X', casing.or(abilities)).where('T', MetaTileEntityAdvancedChemicalPlant.tieredCasing().or(casing)).where('P', MetaTileEntityAdvancedChemicalPlant.states((IBlockState[])new IBlockState[]{this.getPipeCasingState()})).where('C', MetaTileEntityAdvancedChemicalPlant.heatingCoils().setMinGlobalLimited(12).setMaxGlobalLimited(12)).where(' ', MetaTileEntityAdvancedChemicalPlant.any()).build();
    }

    public boolean isTiered() {
        return true;
    }

    public boolean canBeDistinct() {
        return true;
    }

    public boolean isParallel() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.INERT_PTFE_CASING;
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.PTFE_INERT_CASING);
    }

    protected IBlockState getPipeCasingState() {
        return MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.POLYTETRAFLUOROETHYLENE_PIPE);
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gtexpert.machine.advanced_chemical_plant.tooltip.1", (Object[])new Object[0]));
        tooltip.add(TooltipHelper.RAINBOW_SLOW + I18n.func_135052_a((String)"gregtech.machine.perfect_oc", (Object[])new Object[0]));
    }

    @NotNull
    protected TextureArea getLogo() {
        return GTEGuiTextures.GTE_LOGO_DARK;
    }

    @NotNull
    protected TextureArea getWarningLogo() {
        return GTEGuiTextures.GTE_LOGO_BLINKING_YELLOW;
    }

    @NotNull
    protected TextureArea getErrorLogo() {
        return GTEGuiTextures.GTE_LOGO_BLINKING_RED;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.CHEMICAL_REACTOR_OVERLAY;
    }

    private class AdvancedChemicalPlantWorkableHandler
    extends GCYMMultiblockRecipeLogic {
        public AdvancedChemicalPlantWorkableHandler(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
        }

        protected int[] runOverclockingLogic(@NotNull IRecipePropertyStorage propertyStorage, int recipeEUt, long maxVoltage, int duration, int amountOC) {
            return OverclockingLogic.standardOverclockingLogic((int)Math.abs(recipeEUt), (long)maxVoltage, (int)duration, (int)amountOC, (double)this.getOverclockingDurationDivisor(), (double)this.getOverclockingVoltageMultiplier());
        }

        protected double getOverclockingDurationDivisor() {
            return 4.0;
        }

        protected double getOverclockingVoltageMultiplier() {
            return 4.0;
        }
    }
}

