/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.common.metatileentities.multi;

import com.github.gtexpert.core.api.gui.GTEGuiTextures;
import gregicality.multiblocks.api.metatileentity.GCYMRecipeMapMultiblockController;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityLargeRockBreaker
extends GCYMRecipeMapMultiblockController {
    public MetaTileEntityLargeRockBreaker(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.ROCK_BREAKER_RECIPES);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLargeRockBreaker(this.metaTileEntityId);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        TraceabilityPredicate casing = MetaTileEntityLargeRockBreaker.states((IBlockState[])new IBlockState[]{this.getCasingState()});
        TraceabilityPredicate abilities = this.autoAbilities(true, true, true, true, false, false, false);
        return FactoryBlockPattern.start().aisle(new String[]{"CXXXC", "CXXXC", "C   C", "C   C", "C   C", "CCCCC", "  C  ", "     "}).aisle(new String[]{"XCCCX", "X   X", "     ", "  P  ", "  P  ", "CPPPC", " CPC ", "  C  "}).aisle(new String[]{"XCCCX", "X   X", "  C  ", " PCP ", " PCP ", "CPCPC", "CP#PC", " CHC "}).aisle(new String[]{"XCCCX", "X   X", "     ", "  P  ", "  P  ", "CPPPC", " CPC ", "  C  "}).aisle(new String[]{"CXTXC", "CXSXC", "C   C", "C   C", "C   C", "CCCCC", "  C  ", "     "}).where('S', this.selfPredicate()).where('C', casing).where('X', casing.or(abilities)).where('P', MetaTileEntityLargeRockBreaker.states((IBlockState[])new IBlockState[]{this.getPipeCasingState()})).where('T', MetaTileEntityLargeRockBreaker.tieredCasing().or(casing)).where('H', MetaTileEntityLargeRockBreaker.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH})).where('#', MetaTileEntityLargeRockBreaker.air()).where(' ', MetaTileEntityLargeRockBreaker.any()).build();
    }

    public boolean allowsExtendedFacing() {
        return false;
    }

    public boolean allowsFlip() {
        return false;
    }

    public boolean isTiered() {
        return true;
    }

    public boolean canBeDistinct() {
        return true;
    }

    public boolean isParallel() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.SOLID_STEEL_CASING;
    }

    protected IBlockState getPipeCasingState() {
        return MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.STEEL_PIPE);
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STEEL_SOLID);
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gtexpert.machine.large_rock_breaker.tooltip.1", (Object[])new Object[0]));
    }

    @NotNull
    protected TextureArea getLogo() {
        return GTEGuiTextures.GTE_LOGO_DARK;
    }

    @NotNull
    protected TextureArea getWarningLogo() {
        return GTEGuiTextures.GTE_LOGO_BLINKING_YELLOW;
    }

    @NotNull
    protected TextureArea getErrorLogo() {
        return GTEGuiTextures.GTE_LOGO_BLINKING_RED;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.ROCK_BREAKER_OVERLAY;
    }
}

