/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.integration.deda.recipemaps.tierup;

import com.brandon3055.draconicevolution.lib.ToolUpgradeRecipe;
import com.github.gtexpert.core.api.util.GTELog;
import com.github.gtexpert.core.integration.deda.recipemaps.tierup.TierUpRecipeProperty;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.chance.output.ChancedOutputList;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.ValidationResult;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TierUpRecipeBuilder
extends RecipeBuilder<TierUpRecipeBuilder> {
    private GTRecipeInput catalyst;
    private ItemStack result;

    public TierUpRecipeBuilder() {
    }

    public TierUpRecipeBuilder(TierUpRecipeBuilder recipeBuilder) {
        super((RecipeBuilder)recipeBuilder);
    }

    public TierUpRecipeBuilder copy() {
        return new TierUpRecipeBuilder(this);
    }

    public boolean applyProperty(@NotNull String key, @Nullable Object value) {
        if (!key.equals("draconic_fusion_tier_up")) {
            return super.applyProperty(key, value);
        }
        if (!(value instanceof ToolUpgradeRecipe)) {
            GTELog.logger.error("Property for draconic upgrade must be an instance of ToolUpgradeRecipe!", new Throwable());
        }
        this.applyProperty(TierUpRecipeProperty.getInstance(), value);
        return true;
    }

    protected EnumValidationResult validate() {
        super.validate();
        if (this.catalyst == null) {
            GTELog.logger.error("Catalyst has not been set", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (this.result == null) {
            GTELog.logger.error("Result has not been set", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (!this.outputs.isEmpty()) {
            GTELog.logger.error("Do not manually add item output", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        return this.recipeStatus;
    }

    public ValidationResult<Recipe> build() {
        EnumValidationResult validationResult = this.finalizeAndValidate();
        if (validationResult != EnumValidationResult.INVALID) {
            this.setFusionProperties();
        }
        return ValidationResult.newResult((EnumValidationResult)validationResult, (Object)new Recipe(this.inputs, this.outputs, new ChancedOutputList(this.chancedOutputLogic, this.chancedOutputs), this.fluidInputs, this.fluidOutputs, new ChancedOutputList(this.chancedFluidOutputLogic, this.chancedFluidOutputs), this.duration, this.EUt, this.hidden, this.isCTRecipe, this.recipePropertyStorage, this.category));
    }

    private void setFusionProperties() {
        this.setFusionRecipe(new ToolUpgradeRecipe(this.result, this.catalyst.getInputStacks()[0], 0, 0, new Object[]{new ItemStack(Blocks.DIRT)}));
        this.inputs.add(0, this.catalyst);
        this.outputs.add(this.result);
    }

    public TierUpRecipeBuilder catalyst(GTRecipeInput catalyst) {
        this.catalyst = catalyst;
        return this;
    }

    public TierUpRecipeBuilder catalyst(ItemStack itemStack, NBTMatcher any, NBTCondition nbtCondition) {
        return this.catalyst(new GTRecipeItemInput(itemStack).setNBTMatchingCondition(any, nbtCondition));
    }

    public TierUpRecipeBuilder catalyst(ItemStack catalyst) {
        return this.catalyst((GTRecipeInput)new GTRecipeItemInput(catalyst));
    }

    public TierUpRecipeBuilder result(ItemStack result) {
        this.result = result;
        return this;
    }

    public void setFusionRecipe(ToolUpgradeRecipe fusionRecipe) {
        this.applyProperty(TierUpRecipeProperty.getInstance(), fusionRecipe);
    }

    public GTRecipeInput getCatalyst() {
        return this.catalyst;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ToolUpgradeRecipe getFusionRecipe() {
        return this.recipePropertyStorage == null ? null : (ToolUpgradeRecipe)this.recipePropertyStorage.getRecipePropertyValue((RecipeProperty)TierUpRecipeProperty.getInstance(), null);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(TierUpRecipeProperty.getInstance().getKey(), (Object)this.getFusionRecipe()).toString();
    }
}

