/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.common.items.armor;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.armor.ArmorLogicSuite;
import gregtech.api.util.GTUtility;
import gregtech.api.util.input.KeyBind;
import gregtech.common.items.armor.IStepAssist;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class PistonBoots
extends ArmorLogicSuite
implements IStepAssist {
    private float charge = 0.0f;

    public PistonBoots(EntityEquipmentSlot slot, int energyPerUse, long maxCapacity, int tier) {
        super(energyPerUse, maxCapacity, tier, slot);
    }

    public void onArmorTick(@NotNull World world, @NotNull EntityPlayer player, @NotNull ItemStack itemStack) {
        IElectricItem container = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        NBTTagCompound data = GTUtility.getOrCreateNbtCompound((ItemStack)itemStack);
        this.updateStepHeight(player);
        if (container.canUse((long)(this.energyPerUse / 100)) && player.field_70122_E && KeyBind.VANILLA_FORWARD.isKeyDown(player) && player.func_70051_ag()) {
            byte consumerTicks = data.func_74771_c("consumerTicks");
            if ((consumerTicks = (byte)(consumerTicks + 1)) >= 10) {
                consumerTicks = 0;
                container.discharge((long)(this.energyPerUse / 100), container.getTier(), true, false, false);
            }
            data.func_74774_a("consumerTicks", consumerTicks);
            player.func_191958_b(0.0f, 0.0f, 0.25f, 0.1f);
        }
        if (!world.field_72995_K) {
            boolean onGround;
            boolean bl = onGround = !data.func_74764_b("onGround") || data.func_74767_n("onGround");
            if (onGround && !player.field_70122_E && KeyBind.VANILLA_JUMP.isKeyDown(player)) {
                container.discharge((long)(this.energyPerUse / 100), container.getTier(), true, false, false);
            }
            if (player.field_70122_E != onGround) {
                data.func_74757_a("onGround", player.field_70122_E);
            }
        } else {
            if (container.canUse((long)(this.energyPerUse / 100)) && player.field_70122_E) {
                this.charge = 1.0f;
            }
            if (player.field_70181_x >= 0.0 && this.charge > 0.0f && !player.func_70090_H()) {
                if (KeyBind.VANILLA_JUMP.isKeyDown(player)) {
                    if (this.charge == 1.0f) {
                        player.field_70159_w *= 1.4;
                        player.field_70179_y *= 1.4;
                        world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187715_dR, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                    player.field_70181_x += (double)(this.charge * 0.13f);
                    this.charge = (float)((double)this.charge * 0.7);
                } else if (this.charge < 1.0f) {
                    this.charge = 0.0f;
                }
            }
        }
        player.field_71069_bz.func_75142_b();
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @NotNull ItemStack armor, DamageSource source, double damage, EntityEquipmentSlot equipmentSlot) {
        IElectricItem container = (IElectricItem)armor.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        int damageLimit = Integer.MAX_VALUE;
        if (source == DamageSource.field_76379_h) {
            if (this.energyPerUse > 0 && container != null) {
                damageLimit = (int)Math.min((double)damageLimit, 25.0 * (double)container.getCharge() / ((double)this.energyPerUse * 10.0));
            }
            return new ISpecialArmor.ArmorProperties(10, damage <= 5.0 ? 0.0 : damage - 5.0, damageLimit);
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public EntityEquipmentSlot getEquipmentSlot(ItemStack itemStack) {
        return this.SLOT;
    }

    public void damageArmor(EntityLivingBase entity, @NotNull ItemStack itemStack, DamageSource source, int damage, EntityEquipmentSlot equipmentSlot) {
        IElectricItem item = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (item != null) {
            item.discharge((long)this.energyPerUse / 10L * (long)damage, item.getTier(), true, false, false);
        }
    }

    public double getDamageAbsorption() {
        return 0.0;
    }

    @NotNull
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "gtexpert:textures/armor/piston_boots.png";
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldDrawHUD() {
        return false;
    }
}

