/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.core.deploader;

import com.github.gtexpert.core.core.GTECoreMod;
import com.github.gtexpert.core.core.deploader.DownloadProgressDialog;
import com.github.gtexpert.core.core.deploader.LetsEncryptAdder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.minecraftforge.fml.relauncher.IFMLCallHook;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DepLoader
implements IFMLCallHook {
    private File mcLocation;
    private static final Logger LOGGER = LogManager.getLogger(DepLoader.class);
    private DownloadProgressDialog dialog = null;

    public void injectData(Map<String, Object> data) {
        this.mcLocation = (File)data.get("mcLocation");
    }

    public Void call() throws Exception {
        boolean downloaded;
        block33: {
            List deps;
            Gson g = new GsonBuilder().disableHtmlEscaping().create();
            File config = new File(this.mcLocation, "config" + File.separator + "dependencies.json");
            if (!config.exists()) {
                LOGGER.info("No dependencies found.");
                return null;
            }
            try (FileReader fr = new FileReader(config);){
                deps = (List)g.fromJson((Reader)fr, new TypeToken<List<Dependency>>(){}.getType());
            }
            if (deps.isEmpty()) {
                LOGGER.info("No dependencies found.");
                return null;
            }
            long disabledDepCount = deps.stream().filter(Dependency::isDisabled).count();
            long foundDepCount = deps.stream().filter(Dependency::isFound).count();
            LOGGER.info("Found {} dependencies. {} are disabled, {} are found.", (Object)deps.size(), (Object)disabledDepCount, (Object)foundDepCount);
            downloaded = false;
            Thread netThread = null;
            try {
                this.dialog = new DownloadProgressDialog();
                final Thread mainThread = Thread.currentThread();
                this.dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        mainThread.interrupt();
                    }
                });
                this.precheck(deps);
                int count = 0;
                for (Dependency d : deps) {
                    if (d.isDisabled() || d.isFound()) continue;
                    ++count;
                }
                if (count <= 0) break block33;
                LOGGER.info("{} dependencies to download.", (Object)count);
                try {
                    LetsEncryptAdder.addLetsEncryptCertificates();
                }
                catch (Exception e) {
                    LOGGER.warn("Could not ensure Let's Encrypt root certificates are present, downloads might fail on older Java versions.");
                }
                downloaded = true;
                this.dialog.setJobCount(count);
                SwingUtilities.invokeLater(() -> this.dialog.setVisible(true));
                Downloader downloader = new Downloader(deps);
                netThread = new Thread(downloader);
                netThread.setDaemon(true);
                netThread.start();
                netThread.join();
                if (downloader.e != null) {
                    throw new Exception("Download error", downloader.e);
                }
            }
            catch (InterruptedException e) {
                try {
                    Files.delete(new File(this.mcLocation, ".__gtexpert_download_temp__").toPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.dialog != null) {
                    this.dialog.dispose();
                }
                netThread.interrupt();
                netThread.join(500L);
                throw new RuntimeException("Launch cancelled by user");
            }
            catch (Exception e) {
                if (this.dialog != null) {
                    this.dialog.dispose();
                }
                JOptionPane.showMessageDialog(null, "Download of additional files failed. Please refer to log for more info.", "GTExpertCore", 0);
                throw new RuntimeException("Download of additional files failed. Please refer to log for more info.", e);
            }
            finally {
                if (GTECoreMod.downloadOnlyOnce) {
                    try (FileWriter fw = new FileWriter(config);){
                        g.toJson((Object)deps, (Appendable)fw);
                    }
                }
            }
        }
        this.dialog.dispose();
        if (downloaded) {
            JOptionPane.showMessageDialog(null, "Download complete! Please close this dialog now and launch the game from your launcher again to enjoy the pack.", "GTExpertCore", 1);
            throw new RuntimeException("Restart the game please.");
        }
        return null;
    }

    private void precheck(List<Dependency> deps) {
        for (Dependency dep : deps) {
            File location;
            if (dep.isDisabled() || !(location = new File(this.mcLocation, dep.getPath())).exists()) continue;
            if (location.isDirectory()) {
                LOGGER.warn("Directory {} will be removed as it should be a mod jar!", (Object)dep.getPath());
                try {
                    Files.delete(location.toPath());
                    continue;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, String.format("Path %s is expected to be a mod jar, but it is a directory! Please check what's inside manually and move it. This pack cannot continue without that directory removed!", location.toString()));
                    throw new RuntimeException(e);
                }
            }
            LOGGER.debug("Dependency {} found locally", (Object)dep.getPath());
            dep.setFound(true);
        }
    }

    private void download(Dependency dep) throws IOException {
        Path downloadTemp = new File(this.mcLocation, ".__gtexpert_download_temp__").toPath();
        LOGGER.info("Downloading {} to {}", (Object)dep.getUrl(), (Object)dep.getPath());
        try (FileChannel fc = FileChannel.open(downloadTemp, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
             ReadableByteChannel net = Channels.newChannel(new URL(dep.getUrl()).openStream());){
            fc.transferFrom(net, 0L, Long.MAX_VALUE);
        }
        Path target = new File(this.mcLocation, dep.getPath()).toPath();
        Path dir = target.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        Files.move(downloadTemp, target, new CopyOption[0]);
        this.dialog.progress();
    }

    public static class Dependency {
        private String url;
        private String path;
        private boolean disabled;
        private transient boolean found;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        public boolean isFound() {
            return this.found;
        }

        public void setFound(boolean found) {
            this.found = found;
        }
    }

    private class Downloader
    implements Runnable {
        List<Dependency> deps;
        Exception e = null;

        Downloader(List<Dependency> deps) {
            this.deps = deps;
        }

        @Override
        public void run() {
            try {
                if (!this.deps.isEmpty()) {
                    for (Dependency dep : this.deps) {
                        if (!dep.isDisabled() && !dep.isFound()) {
                            DepLoader.this.download(dep);
                        }
                        if (!GTECoreMod.downloadOnlyOnce) continue;
                        dep.setDisabled(true);
                    }
                }
            }
            catch (Exception ex) {
                this.e = ex;
            }
        }
    }
}

