/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.integration.theoneprobe.provider;

import com.github.gtexpert.core.integration.eio.metatileentities.MetaTileEntityElectricSpawner;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ElectricSpawnerInfoProvider
implements IProbeInfoProvider {
    public String getID() {
        return "gtexpert:electric_spawner";
    }

    public void addProbeInfo(@NotNull ProbeMode mode, @NotNull IProbeInfo probeInfo, @NotNull EntityPlayer player, @NotNull World world, @NotNull IBlockState blockState, @NotNull IProbeHitData data) {
        if (!blockState.func_177230_c().hasTileEntity(blockState)) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(data.getPos());
        if (!(tileEntity instanceof MetaTileEntityHolder)) {
            return;
        }
        MetaTileEntityHolder mteHolder = (MetaTileEntityHolder)tileEntity;
        MetaTileEntity mte = mteHolder.getMetaTileEntity();
        if (!(mte instanceof MetaTileEntityElectricSpawner)) {
            return;
        }
        MetaTileEntityElectricSpawner spawner = (MetaTileEntityElectricSpawner)mte;
        probeInfo.text(TextStyleClass.WARNING + "{*" + spawner.getSpawnModeTranslationKey() + "*}");
        if (spawner.needsRedstone()) {
            probeInfo.text(TextStyleClass.WARNING + "{*gtexpert.gui.needs_redstone*}");
        }
    }
}

