/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.core;

import com.github.gtexpert.core.api.util.GTELog;
import java.util.Iterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class NAE2PatchTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if ("co.neeve.nae2.mixin.upgrades.gregcircuit.MixinDualityInterface".equals(transformedName)) {
            return this.patchMixinDualityInterface(basicClass);
        }
        return basicClass;
    }

    private byte[] patchMixinDualityInterface(byte[] classBytes) {
        try {
            GTELog.logger.info("Patching NAE2 MixinDualityInterface to remove craftingList references");
            ClassReader classReader = new ClassReader(classBytes);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            boolean modified = false;
            Iterator fieldIterator = classNode.fields.iterator();
            block2: while (fieldIterator.hasNext()) {
                FieldNode field = (FieldNode)fieldIterator.next();
                if (!"craftingList".equals(field.name) || field.visibleAnnotations == null) continue;
                for (AnnotationNode annotation : field.visibleAnnotations) {
                    if (!"Lorg/spongepowered/asm/mixin/Shadow;".equals(annotation.desc)) continue;
                    GTELog.logger.info("Removing @Shadow craftingList field from NAE2 MixinDualityInterface");
                    fieldIterator.remove();
                    modified = true;
                    continue block2;
                }
            }
            Iterator methodIterator = classNode.methods.iterator();
            while (methodIterator.hasNext()) {
                MethodNode method = (MethodNode)methodIterator.next();
                if (!method.name.contains("injectInventoryChange") && !method.name.contains("handler$") || method.instructions == null) continue;
                boolean methodModified = false;
                for (AbstractInsnNode insn : method.instructions) {
                    if (insn.getOpcode() != 180 && insn.getOpcode() != 181) continue;
                    FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                    if (!"craftingList".equals(fieldInsn.name)) continue;
                    GTELog.logger.info("Found reference to craftingList in method {}, removing the method entirely", (Object)method.name);
                    methodIterator.remove();
                    modified = true;
                    methodModified = true;
                    break;
                }
                if (!methodModified) continue;
            }
            if (modified) {
                ClassWriter classWriter = new ClassWriter(1);
                classNode.accept((ClassVisitor)classWriter);
                GTELog.logger.info("Successfully patched NAE2 MixinDualityInterface");
                return classWriter.toByteArray();
            }
            GTELog.logger.info("No craftingList references found in MixinDualityInterface");
        }
        catch (Exception e) {
            GTELog.logger.error("Failed to patch NAE2 MixinDualityInterface: {}", (Object)e.getMessage(), (Object)e);
        }
        return classBytes;
    }
}

