/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.integration.deda.recipemaps;

import cofh.redstoneflux.api.IEnergyContainerItem;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.fusioncrafting.SimpleFusionRecipe;
import com.brandon3055.draconicevolution.api.itemupgrade.FusionUpgradeRecipe;
import com.brandon3055.draconicevolution.api.itemupgrade.IUpgradableItem;
import com.brandon3055.draconicevolution.items.ToolUpgrade;
import com.github.gtexpert.core.api.util.GTELog;
import com.github.gtexpert.core.integration.deda.recipemaps.tierup.TierUpRecipeBuilder;
import com.github.gtexpert.core.integration.deda.recipemaps.tierup.TierUpRecipeProperty;
import com.github.gtexpert.core.integration.deda.recipemaps.upgrade.UpgradeRecipeBuilder;
import com.github.gtexpert.core.integration.deda.recipemaps.upgrade.UpgradeRecipeProperty;
import gregtech.api.capability.FeCompat;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeMapDraconicFusion
extends RecipeMap<SimpleRecipeBuilder> {
    private final RecipeMap<TierUpRecipeBuilder> tierUpRecipeMap;
    private final RecipeMap<UpgradeRecipeBuilder> upgradeRecipeMap;

    public RecipeMapDraconicFusion(@NotNull String unlocalizedName, int maxInputs, int maxOutputs, int maxFluidInputs, int maxFluidOutputs, @NotNull SimpleRecipeBuilder defaultRecipeBuilder, boolean isHidden, RecipeMap<TierUpRecipeBuilder> tierUpRecipeMap, RecipeMap<UpgradeRecipeBuilder> upgradeRecipeMap) {
        super(unlocalizedName, maxInputs, maxOutputs, maxFluidInputs, maxFluidOutputs, (RecipeBuilder)defaultRecipeBuilder, isHidden);
        this.tierUpRecipeMap = tierUpRecipeMap;
        this.upgradeRecipeMap = upgradeRecipeMap;
    }

    @Nullable
    public Recipe findRecipe(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, boolean exactVoltage) {
        Recipe superRecipe = super.findRecipe(voltage, inputs, fluidInputs, exactVoltage);
        if (superRecipe != null) {
            return superRecipe;
        }
        this.applyDefaultUpgradeTag(inputs);
        Recipe tierUpRecipe = this.tierUpRecipeMap.findRecipe(voltage, inputs, fluidInputs, exactVoltage);
        if (tierUpRecipe != null) {
            return this.setupOutput(tierUpRecipe, inputs, (IFusionRecipe)tierUpRecipe.getProperty((RecipeProperty)TierUpRecipeProperty.getInstance(), null));
        }
        for (Recipe recipe : this.upgradeRecipeMap.getRecipeList()) {
            if ((long)recipe.getEUt() > voltage || !recipe.matches(false, inputs, fluidInputs)) continue;
            return this.setupOutput(recipe, inputs, (IFusionRecipe)recipe.getProperty((RecipeProperty)UpgradeRecipeProperty.getInstance(), null));
        }
        return null;
    }

    private void applyDefaultUpgradeTag(List<ItemStack> inputs) {
        for (ItemStack input : inputs) {
            Item item = input.getItem();
            if (!(item instanceof IUpgradableItem)) continue;
            IUpgradableItem item2 = (IUpgradableItem)item;
            for (String upgradeName : ToolUpgrade.NAME_TO_ID.keySet()) {
                NBTTagCompound upgradeTag;
                if (!item2.getValidUpgrades(input).contains(upgradeName) || (upgradeTag = input.getOrCreateSubCompound("DEUpgrades")).hasKey(upgradeName, 1)) continue;
                upgradeTag.setByte(upgradeName, (byte)0);
            }
        }
    }

    private Recipe setupOutput(Recipe gtRecipe, List<ItemStack> inputs, IFusionRecipe fusionRecipe) {
        if (fusionRecipe == null) {
            GTELog.logger.warn("Recipe found, but property not found");
            GTELog.logger.warn("Recipe: " + gtRecipe);
            return null;
        }
        ItemStack catalyst = this.findCatalyst(inputs, fusionRecipe);
        if (catalyst.isEmpty()) {
            GTELog.logger.warn("Recipe found, but actual catalyst not found in the GT recipe");
            GTELog.logger.warn("Recipe: " + gtRecipe);
            GTELog.logger.warn("Expected catalyst: " + fusionRecipe.getRecipeCatalyst());
            return null;
        }
        ItemStack outputStack = fusionRecipe.getRecipeOutput(catalyst);
        IElectricItem inputElectricItem = (IElectricItem)catalyst.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (inputElectricItem != null) {
            long euCharge = inputElectricItem.getCharge();
            int feCharge = (int)Math.min(euCharge * (long)FeCompat.ratio((boolean)false), Integer.MAX_VALUE);
            Item item = outputStack.getItem();
            if (item instanceof IEnergyContainerItem) {
                IEnergyContainerItem outputEnergyItem = (IEnergyContainerItem)item;
                ItemNBTHelper.setInteger((ItemStack)outputStack, (String)"Energy", (int)Math.min(feCharge, outputEnergyItem.getMaxEnergyStored(outputStack)));
            }
        }
        Recipe retRecipe = gtRecipe.copy();
        retRecipe.getOutputs().clear();
        retRecipe.getOutputs().add((Object)outputStack);
        return retRecipe;
    }

    @NotNull
    private ItemStack findCatalyst(List<ItemStack> inputs, IFusionRecipe fusionRecipe) {
        ItemStack expectedCatalyst = RecipeMapDraconicFusion.getCatalyst(fusionRecipe);
        if (expectedCatalyst == null || expectedCatalyst.isEmpty()) {
            return ItemStack.EMPTY;
        }
        for (ItemStack input : inputs) {
            if (expectedCatalyst.getItem() != input.getItem() || expectedCatalyst.getItemDamage() != input.getItemDamage() || !fusionRecipe.isRecipeCatalyst(input)) continue;
            return input;
        }
        return ItemStack.EMPTY;
    }

    @Nullable
    private static ItemStack getCatalyst(IFusionRecipe fusionRecipe) {
        if (fusionRecipe instanceof SimpleFusionRecipe) {
            return fusionRecipe.getRecipeCatalyst();
        }
        if (fusionRecipe instanceof FusionUpgradeRecipe) {
            List ingredients = ((FusionUpgradeRecipe)fusionRecipe).getRecipeIngredients();
            if (ingredients.isEmpty() || !(ingredients.get(0) instanceof ItemStack)) {
                GTELog.logger.warn("Unknown ingredient: " + (ingredients.isEmpty() ? "empty" : ingredients.get(0)));
                GTELog.logger.warn("Recipe: " + fusionRecipe);
                return null;
            }
            return (ItemStack)ingredients.get(0);
        }
        throw new RuntimeException("Unknown type of IFusionRecipe: " + fusionRecipe.getClass().getName());
    }
}

