/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.mixins;

import com.github.gtexpert.core.api.util.GTELog;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.Loader;
import zone.rong.mixinbooter.ILateMixinLoader;

public class GTEMixinLoader
implements ILateMixinLoader {
    public static final Map<String, Boolean> modMixinsConfig = new ImmutableMap.Builder().put((Object)"draconicadditions", (Object)true).put((Object)"gregtech", (Object)true).put((Object)"gcym", (Object)true).build();

    public List<String> getMixinConfigs() {
        return modMixinsConfig.keySet().stream().map(mod -> "mixins.gtexpert." + mod + ".json").collect(Collectors.toList());
    }

    public boolean shouldMixinConfigQueue(String mixinConfig) {
        String[] parts = mixinConfig.split("\\.");
        if (parts.length != 4 && parts.length != 5) {
            GTELog.logger.fatal("Mixin Config Check Failed! Invalid Length.");
            GTELog.logger.fatal("Mixin Config: {}", (Object)mixinConfig);
            return true;
        }
        if (!Objects.equals(parts[1], "gtexpert")) {
            GTELog.logger.error("Non GTExpertCore Mixin Found in Mixin Queue. This is probably an error. Skipping...");
            GTELog.logger.error("Mixin Config: {}", (Object)mixinConfig);
            return true;
        }
        if (!Loader.isModLoaded((String)parts[2])) {
            GTELog.logger.error("Mod '{}' is not loaded. If this is a normal GTExpertCore instance, this is probably an error.", (Object)parts[2]);
            GTELog.logger.error("Not Loading Mixin Config {}", (Object)mixinConfig);
            return false;
        }
        if (!modMixinsConfig.containsKey(parts[2]) || !modMixinsConfig.get(parts[2]).booleanValue()) {
            GTELog.logger.info("Integration for Mod '{}' is not enabled, or does not exist.", (Object)parts[2]);
            GTELog.logger.info("Not Loading Mixin Config {}", (Object)mixinConfig);
            return false;
        }
        return true;
    }
}

