/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.integration.deda.recipes;

import com.brandon3055.draconicevolution.DEFeatures;
import com.github.gtexpert.core.api.GTEValues;
import com.github.gtexpert.core.api.unification.material.GTEMaterials;
import com.github.gtexpert.core.api.util.Mods;
import gregicality.multiblocks.api.fluids.GCYMFluidStorageKeys;
import gregicality.multiblocks.api.recipes.GCYMRecipeMaps;
import gregicality.multiblocks.api.unification.GCYMMaterialFlags;
import gregicality.multiblocks.api.unification.properties.GCYMPropertyKey;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.metatileentity.multiblock.CleanroomType;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.BlastRecipeBuilder;
import gregtech.api.recipes.builders.ImplosionRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class DraconicMaterialsRecipe {
    public static final int ABFPyrotheumAmount = 200;
    public static final double ABFDurationMultiplier = 0.5;

    public static void init() {
        RecipeBuilder builderDD = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder()).input(OrePrefix.dust, Materials.Iridium, 1)).fluidInputs(new FluidStack[]{Materials.SaltWater.getFluid(1000)})).fluidInputs(new FluidStack[]{Materials.EnderEye.getFluid(144)})).cleanroom(CleanroomType.CLEANROOM)).output(OrePrefix.dust, GTEMaterials.Dragon, 2)).duration(600)).EUt(GTValues.VA[GTEValues.dedaVoltageTier]);
        if (Mods.EnderIO.isModLoaded()) {
            builderDD.input(OrePrefix.dust, GTEMaterials.EndSteel, 1);
        } else {
            builderDD.input(OrePrefix.dust, Materials.Endstone, 1);
        }
        builderDD.buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder()).input(Blocks.field_150380_bt)).output(OrePrefix.dust, GTEMaterials.Dragon, 8)).duration(200)).EUt(GTValues.VA[GTEValues.dedaVoltageTier])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder()).input(OrePrefix.dust, GTEMaterials.Dragon, 8)).fluidInputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 8000)})).fluidInputs(new FluidStack[]{GTEMaterials.AwakenedDraconium.getFluid(1152)})).cleanroom(CleanroomType.CLEANROOM)).output(OrePrefix.dust, GTEMaterials.Chaos, 2)).duration(1200)).EUt(GTValues.VA[GTEValues.dedaVoltageTier + 1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder()).inputs(new ItemStack[]{new ItemStack((Item)DEFeatures.chaosShard, 1, 1)})).output(OrePrefix.dust, GTEMaterials.Chaos, 1)).duration(200)).EUt(GTValues.VA[GTEValues.dedaVoltageTier + 1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder()).input(OrePrefix.dust, GTEMaterials.Chaos, 1)).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(50)})).output((Item)DEFeatures.chaosShard, 1, 1)).duration(1200)).EUt(GTValues.VA[GTEValues.dedaVoltageTier + 1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder()).input(OrePrefix.dust, GTEMaterials.Chaos, 1)).fluidInputs(new FluidStack[]{Materials.Water.getFluid(250)})).chancedOutput(new ItemStack((Item)DEFeatures.chaosShard, 1, 1), 7000, 1000)).duration(2400)).EUt(GTValues.VA[GTEValues.dedaVoltageTier + 1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CHEMICAL_RECIPES.recipeBuilder()).input(OrePrefix.dust, GTEMaterials.Dragon, 1)).input(OrePrefix.dust, Materials.Obsidian, 1)).fluidInputs(new FluidStack[]{Materials.LiquidEnderAir.getFluid(8000)})).fluidInputs(new FluidStack[]{Materials.EnderPearl.getFluid(576)})).output(OrePrefix.dust, GTEMaterials.Draconium, 2)).duration(100)).EUt(GTValues.VA[GTEValues.dedaVoltageTier])).buildAndRegister();
        ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("draconium_block"));
        ModHandler.addMirroredShapedRecipe((String)"de_draconium_block", (ItemStack)new ItemStack((Block)DEFeatures.draconiumBlock), (Object[])new Object[]{"B", Character.valueOf('B'), OreDictUnifier.get((OrePrefix)OrePrefix.block, (Material)GTEMaterials.Draconium)});
        ModHandler.addMirroredShapedRecipe((String)"ceu_draconium_block", (ItemStack)OreDictUnifier.get((OrePrefix)OrePrefix.block, (Material)GTEMaterials.Draconium), (Object[])new Object[]{"B", Character.valueOf('B'), new ItemStack((Block)DEFeatures.draconiumBlock)});
        ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("draconic_block"));
        ModHandler.addMirroredShapedRecipe((String)"de_draconic_block", (ItemStack)new ItemStack((Block)DEFeatures.draconicBlock), (Object[])new Object[]{"B", Character.valueOf('B'), OreDictUnifier.get((OrePrefix)OrePrefix.block, (Material)GTEMaterials.AwakenedDraconium)});
        ModHandler.addMirroredShapedRecipe((String)"ceu_draconic_block", (ItemStack)OreDictUnifier.get((OrePrefix)OrePrefix.block, (Material)GTEMaterials.AwakenedDraconium), (Object[])new Object[]{"B", Character.valueOf('B'), new ItemStack((Block)DEFeatures.draconicBlock)});
        ((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)RecipeMaps.IMPLOSION_RECIPES.recipeBuilder()).input((Item)DEFeatures.dragonHeart, 1)).input(OrePrefix.block, GTEMaterials.Draconium, 4)).output(OrePrefix.block, GTEMaterials.AwakenedDraconium, 3)).explosivesType(new ItemStack((Block)MetaBlocks.POWDERBARREL, 8)).buildAndRegister();
        ((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)RecipeMaps.IMPLOSION_RECIPES.recipeBuilder()).input((Item)DEFeatures.dragonHeart, 1)).input(OrePrefix.block, GTEMaterials.Draconium, 4)).output(OrePrefix.block, GTEMaterials.AwakenedDraconium, 3)).explosivesAmount(4).buildAndRegister();
        ((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)RecipeMaps.IMPLOSION_RECIPES.recipeBuilder()).input((Item)DEFeatures.dragonHeart, 1)).input(OrePrefix.block, GTEMaterials.Draconium, 4)).output(OrePrefix.block, GTEMaterials.AwakenedDraconium, 3)).explosivesType(MetaItems.DYNAMITE.getStackForm(2)).buildAndRegister();
        ((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)RecipeMaps.IMPLOSION_RECIPES.recipeBuilder()).input((Item)DEFeatures.dragonHeart, 1)).input(OrePrefix.block, GTEMaterials.Draconium, 4)).output(OrePrefix.block, GTEMaterials.AwakenedDraconium, 3)).explosivesType(new ItemStack((Block)MetaBlocks.ITNT)).buildAndRegister();
        ArrayList materials = new ArrayList(GregTechAPI.materialManager.getRegisteredMaterials());
        materials.forEach(DraconicMaterialsRecipe::vacuumFreezerExtended);
        materials.forEach(DraconicMaterialsRecipe::alloyBlastFurnaceExtended);
    }

    private static void vacuumFreezerExtended(@NotNull Material material) {
        int vacuumDuration;
        if (!material.hasProperty(GCYMPropertyKey.ALLOY_BLAST)) {
            return;
        }
        Fluid molten = material.getFluid(GCYMFluidStorageKeys.MOLTEN);
        if (molten == null) {
            return;
        }
        BlastProperty property = (BlastProperty)material.getProperty(PropertyKey.BLAST);
        int vacuumEUt = property.getVacuumEUtOverride() != -1 ? property.getVacuumEUtOverride() : GTValues.VA[2];
        int n = vacuumDuration = property.getVacuumDurationOverride() != -1 ? property.getVacuumDurationOverride() : (int)((double)material.getMass() * 0.5);
        if (property.getBlastTemperature() >= 5000) {
            if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_PLATE)).fluidInputs(new FluidStack[]{new FluidStack(molten, 144)})).fluidInputs(new FluidStack[]{GTEMaterials.Cryotheum.getFluid(250)})).fluidOutputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 50)})).output(OrePrefix.plate, material, 1)).duration(vacuumDuration / 2)).EUt(vacuumEUt)).buildAndRegister();
            }
            if (material.hasFlag(MaterialFlags.GENERATE_SMALL_GEAR)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_GEAR_SMALL)).fluidInputs(new FluidStack[]{new FluidStack(molten, 144)})).fluidInputs(new FluidStack[]{GTEMaterials.Cryotheum.getFluid(250)})).fluidOutputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 50)})).output(OrePrefix.gearSmall, material, 1)).duration(vacuumDuration / 2)).EUt(vacuumEUt)).buildAndRegister();
            }
            if (material.hasFlag(MaterialFlags.GENERATE_GEAR)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_GEAR)).fluidInputs(new FluidStack[]{new FluidStack(molten, 576)})).fluidInputs(new FluidStack[]{GTEMaterials.Cryotheum.getFluid(1000)})).fluidOutputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 200)})).output(OrePrefix.gear, material, 1)).duration(vacuumDuration * 2)).EUt(vacuumEUt)).buildAndRegister();
            }
            if (material.hasFlag(MaterialFlags.GENERATE_ROTOR)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_ROTOR)).fluidInputs(new FluidStack[]{new FluidStack(molten, 576)})).fluidInputs(new FluidStack[]{GTEMaterials.Cryotheum.getFluid(1000)})).fluidOutputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 200)})).output(OrePrefix.rotor, material, 1)).duration(vacuumDuration / 2)).EUt(vacuumEUt)).buildAndRegister();
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).input(OrePrefix.ingotHot, material, 1)).fluidInputs(new FluidStack[]{GTEMaterials.Cryotheum.getFluid(250)})).fluidOutputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 50)})).output(OrePrefix.ingot, material, 1)).duration(vacuumDuration / 2)).EUt(vacuumEUt)).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).circuitMeta(1)).fluidInputs(new FluidStack[]{new FluidStack(molten, 144)})).fluidInputs(new FluidStack[]{GTEMaterials.Cryotheum.getFluid(250)})).fluidOutputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 50)})).fluidOutputs(new FluidStack[]{material.getFluid(144)})).duration(vacuumDuration / 2)).EUt(vacuumEUt)).buildAndRegister();
        }
    }

    private static void alloyBlastFurnaceExtended(Material material) {
        if (material.hasFlag(GCYMMaterialFlags.NO_ALLOY_BLAST_RECIPES)) {
            return;
        }
        if (!material.hasProperty(GCYMPropertyKey.ALLOY_BLAST)) {
            return;
        }
        Fluid molten = material.getFluid(GCYMFluidStorageKeys.MOLTEN);
        if (molten == null) {
            return;
        }
        BlastProperty property = (BlastProperty)material.getProperty(PropertyKey.BLAST);
        DraconicMaterialsRecipe.produce(material, property);
    }

    private static void produce(@NotNull Material material, @NotNull BlastProperty blastProperty) {
        int componentAmount = material.getMaterialComponents().size();
        if (componentAmount < 2) {
            return;
        }
        Fluid molten = material.getFluid(GCYMFluidStorageKeys.MOLTEN);
        if (molten == null) {
            return;
        }
        BlastRecipeBuilder builder = DraconicMaterialsRecipe.createBuilder(blastProperty, material);
        int outputAmount = DraconicMaterialsRecipe.addInputs(material, (RecipeBuilder<BlastRecipeBuilder>)builder);
        if (outputAmount <= 0) {
            return;
        }
        DraconicMaterialsRecipe.buildRecipes(blastProperty, molten, outputAmount, componentAmount, (RecipeBuilder<BlastRecipeBuilder>)builder);
    }

    @NotNull
    private static BlastRecipeBuilder createBuilder(@NotNull BlastProperty property, @NotNull Material material) {
        BlastRecipeBuilder builder = (BlastRecipeBuilder)GCYMRecipeMaps.ALLOY_BLAST_RECIPES.recipeBuilder();
        int duration = property.getDurationOverride();
        if (duration < 0) {
            duration = Math.max(1, (int)(material.getMass() * (long)property.getBlastTemperature() / 100L));
        }
        builder.duration(duration);
        int EUt = property.getEUtOverride();
        if (EUt < 0) {
            EUt = GTValues.VA[2];
        }
        builder.EUt(EUt);
        return builder.blastFurnaceTemp(property.getBlastTemperature());
    }

    private static int addInputs(@NotNull Material material, @NotNull RecipeBuilder<BlastRecipeBuilder> builder) {
        int outputAmount = 0;
        int fluidAmount = 0;
        int dustAmount = 0;
        for (MaterialStack materialStack : material.getMaterialComponents()) {
            Material msMat = materialStack.material;
            int msAmount = (int)materialStack.amount;
            if (msMat.hasProperty(PropertyKey.DUST)) {
                if (dustAmount >= 9) {
                    return -1;
                }
                ++dustAmount;
                builder.input(OrePrefix.dust, msMat, msAmount);
            } else if (msMat.hasProperty(PropertyKey.FLUID)) {
                if (fluidAmount >= 2) {
                    return -1;
                }
                ++fluidAmount;
                builder.fluidInputs(new FluidStack[]{msMat.getFluid(1000 * msAmount)});
            } else {
                return -1;
            }
            outputAmount += msAmount;
        }
        return outputAmount;
    }

    private static void buildRecipes(@NotNull BlastProperty property, @NotNull Fluid molten, int outputAmount, int componentAmount, @NotNull RecipeBuilder<BlastRecipeBuilder> builder) {
        builder.fluidOutputs(new FluidStack[]{new FluidStack(molten, 144 * outputAmount)});
        int duration = builder.getDuration() * outputAmount * 3 / 4;
        if (property.getGasTier() != null) {
            RecipeBuilder builderGas = builder.copy();
            ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)builderGas.notConsumable((GTRecipeInput)new IntCircuitIngredient(DraconicMaterialsRecipe.getGasCircuitNum(componentAmount)))).fluidInputs(new FluidStack[]{GTEMaterials.Pyrotheum.getFluid(GCYMFluidStorageKeys.MOLTEN, 200)})).duration((int)((double)duration * 0.67 * 0.5))).buildAndRegister();
        }
        ((BlastRecipeBuilder)((BlastRecipeBuilder)builder.notConsumable((GTRecipeInput)new IntCircuitIngredient(DraconicMaterialsRecipe.getCircuitNum(componentAmount)))).duration(duration)).buildAndRegister();
    }

    private static int getCircuitNum(int componentAmount) {
        return componentAmount;
    }

    private static int getGasCircuitNum(int componentAmount) {
        return componentAmount + 11;
    }

    public static void remove() {
        ModHandler.removeFurnaceSmelting((ItemStack)Mods.DraconicEvolution.getItem("draconium_ore", 1));
        ModHandler.removeFurnaceSmelting((ItemStack)Mods.DraconicEvolution.getItem("draconium_ore", 1, 1));
        ModHandler.removeFurnaceSmelting((ItemStack)Mods.DraconicEvolution.getItem("draconium_ore", 1, 2));
        ModHandler.removeFurnaceSmelting((ItemStack)Mods.DraconicEvolution.getItem("draconium_dust"));
        if (ConfigHolder.recipes.disableManualCompression) {
            ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("nugget"));
            ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("draconium_ingot"));
            ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("draconium_ingot_1"));
            ModHandler.removeFurnaceSmelting((ItemStack)Mods.DraconicEvolution.getItem("draconium_ingot"));
            ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("nugget_1"));
            ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("draconic_ingot"));
            ModHandler.removeRecipeByName((ResourceLocation)Mods.DraconicEvolution.getResource("draconic_ingot_1"));
        }
    }
}

