/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.integration.eio.metatileentities;

import com.enderio.core.client.render.BoundingBox;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.soulvial.ItemSoulVial;
import crazypants.enderio.machines.config.config.SpawnerConfig;
import crazypants.enderio.util.CapturedMob;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.RecipeLogicEnergy;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.logic.OverclockingLogic;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElectricSpawnerLogic
extends RecipeLogicEnergy {
    private boolean spawnMode = true;
    private CapturedMob mobToSpawn;
    private boolean needsRedstone = false;

    public ElectricSpawnerLogic(@NotNull MetaTileEntity metaTileEntity, Supplier<IEnergyContainer> energyContainer) {
        super(metaTileEntity, null, energyContainer);
    }

    public boolean getSpawnMode() {
        return this.spawnMode;
    }

    public void setSpawnMode(boolean spawnMode) {
        this.setSpawnModeSilent(spawnMode);
        this.setActive(false);
        this.progressTime = 0;
        this.setMaxProgress(0);
        this.recipeEUt = 0;
        this.setNeedsRedstone(false);
    }

    private void setSpawnModeSilent(boolean spawnMode) {
        this.spawnMode = spawnMode;
    }

    public boolean needsRedstone() {
        return this.needsRedstone;
    }

    private void setNeedsRedstone(boolean needsRedstone) {
        if (this.needsRedstone != needsRedstone) {
            this.needsRedstone = needsRedstone;
            this.writeCustomData(334, buf -> buf.writeBoolean(needsRedstone));
        }
    }

    protected void updateRecipeProgress() {
        if (this.spawnMode && !this.metaTileEntity.isBlockRedstonePowered()) {
            this.setNeedsRedstone(true);
            return;
        }
        this.setNeedsRedstone(false);
        super.updateRecipeProgress();
    }

    protected void completeRecipe() {
        if (this.spawnMode) {
            this.spawnEntities();
        }
        super.completeRecipe();
        this.mobToSpawn = null;
    }

    protected void trySearchNewRecipe() {
        CapturedMob mobToSpawn = this.findMobToSpawn(this.getInputInventory());
        boolean bl = this.invalidInputsForRecipes = mobToSpawn == null;
        if (this.isCapturedMobInvalid(mobToSpawn)) {
            return;
        }
        this.prepareWork(mobToSpawn);
    }

    @Nullable
    private CapturedMob findMobToSpawn(IItemHandlerModifiable inputs) {
        for (int i = 0; i < inputs.getSlots(); ++i) {
            CapturedMob candidate;
            ItemStack stack = inputs.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof ItemSoulVial) || (candidate = CapturedMob.create((ItemStack)stack)) == null) continue;
            return candidate;
        }
        return null;
    }

    private void prepareWork(@NotNull CapturedMob mobToSpawn) {
        ItemStack outputItem = this.createSoulVial(mobToSpawn);
        if (outputItem.func_190926_b()) {
            return;
        }
        if (!this.setupAndConsumeInputs(outputItem)) {
            return;
        }
        this.setup(mobToSpawn, outputItem);
    }

    private boolean setupAndConsumeInputs(@NotNull ItemStack outputItem) {
        if (!this.checkOverclock()) {
            return false;
        }
        if (this.spawnMode) {
            return true;
        }
        if (!this.metaTileEntity.canVoidRecipeItemOutputs() && !GTTransferUtils.addItemsToItemHandler((IItemHandler)this.getOutputInventory(), (boolean)true, Collections.singletonList(outputItem))) {
            this.isOutputsFull = true;
            return false;
        }
        this.isOutputsFull = false;
        return this.consumeEmptyVial();
    }

    private boolean checkOverclock() {
        int eut = 30;
        int duration = 200;
        this.overclockResults = OverclockingLogic.standardOverclockingLogic((int)eut, (long)this.getMaximumOverclockVoltage(), (int)duration, (int)this.getNumberOfOCs(eut), (double)this.getOverclockingDurationDivisor(), (double)this.getOverclockingVoltageMultiplier());
        return this.hasEnoughPower(this.overclockResults);
    }

    private boolean consumeEmptyVial() {
        IItemHandlerModifiable importInventory = this.getInputInventory();
        for (int slot = 0; slot < importInventory.getSlots(); ++slot) {
            ItemStack stack = importInventory.getStackInSlot(slot);
            if (stack.func_77973_b() != ModObject.itemSoulVial.getItemNN() || stack.func_77942_o()) continue;
            importInventory.extractItem(slot, 1, false);
            return true;
        }
        return false;
    }

    private void setup(@NotNull CapturedMob mobToSpawn, @NotNull ItemStack outputItem) {
        this.progressTime = 1;
        this.setMaxProgress(this.overclockResults[1]);
        this.recipeEUt = this.overclockResults[0];
        this.itemOutputs = !this.spawnMode ? GTUtility.copyStackList(Collections.singletonList(outputItem)) : NonNullList.func_191196_a();
        this.fluidOutputs = NonNullList.func_191196_a();
        this.mobToSpawn = mobToSpawn;
        if (this.wasActiveAndNeedsUpdate) {
            this.wasActiveAndNeedsUpdate = false;
        } else {
            this.setActive(true);
        }
    }

    private void spawnEntities() {
        for (int i = 0; i < (Integer)SpawnerConfig.poweredSpawnerSpawnCount.get(); ++i) {
            this.trySpawnEntity(this.mobToSpawn);
        }
    }

    private void trySpawnEntity(CapturedMob mobToSpawn) {
        World world = this.metaTileEntity.getWorld();
        int spawnRange = (Integer)SpawnerConfig.poweredSpawnerSpawnRange.get();
        Class entityClass = mobToSpawn.getEntityClass();
        if (!this.isAreaClear(world, entityClass, spawnRange, 2, (Integer)SpawnerConfig.poweredSpawnerMaxNearbyEntities.get())) {
            return;
        }
        if (entityClass == null || !EntityLiving.class.isAssignableFrom(entityClass)) {
            return;
        }
        BlockPos pos = this.metaTileEntity.getPos();
        EntityLiving entity = (EntityLiving)this.createEntity(mobToSpawn);
        if (entity == null) {
            return;
        }
        for (int i = 0; i < (Integer)SpawnerConfig.poweredSpawnerMaxSpawnTries.get(); ++i) {
            double x = (double)pos.func_177958_n() + 0.5 + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)spawnRange;
            double y = pos.func_177956_o() + world.field_73012_v.nextInt(3) - 1;
            double z = (double)pos.func_177952_p() + 0.5 + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)spawnRange;
            entity.func_70012_b(x, y, z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (!this.canSpawnEntity(entity)) continue;
            world.func_72838_d((Entity)entity);
            world.func_175718_b(2004, pos, 0);
            entity.func_70656_aK();
            this.addDependents(world, entity);
            return;
        }
        this.cleanupUnspawnedEntity((Entity)entity);
    }

    private boolean isAreaClear(World world, Class<? extends Entity> entityClass, int spawnRangeXZ, int spawnRangeY, int amount) {
        if (amount > 0) {
            return world.func_175647_a(entityClass, (AxisAlignedBB)new BoundingBox(this.metaTileEntity.getPos()).expand((double)spawnRangeXZ, (double)spawnRangeY, (double)spawnRangeXZ), EntitySelectors.field_94557_a).size() < amount;
        }
        return true;
    }

    private boolean canSpawnEntity(EntityLiving entityliving) {
        boolean bl;
        switch ((Boolean)SpawnerConfig.poweredSpawnerUseForgeSpawnChecks.get() != false ? ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)entityliving.field_70170_p, (float)((float)entityliving.field_70165_t), (float)((float)entityliving.field_70163_u), (float)((float)entityliving.field_70161_v), null) : Event.Result.DEFAULT) {
            case ALLOW: {
                bl = true;
                break;
            }
            case DEFAULT: {
                if (((Boolean)SpawnerConfig.poweredSpawnerUseVanillaSpawnChecks.get()).booleanValue()) {
                    if (entityliving.func_70601_bi() && entityliving.func_70058_J()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                bl = entityliving.func_70058_J();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private void addDependents(@NotNull World world, @NotNull EntityLiving entity) {
        Entity ridingEntity = entity.func_184187_bx();
        if (ridingEntity != null) {
            ridingEntity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
            if (!ridingEntity.isAddedToWorld()) {
                world.func_72838_d(ridingEntity);
            }
        }
        for (Entity passenger : entity.func_184188_bt()) {
            passenger.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, 0.0f);
            if (passenger.isAddedToWorld()) continue;
            world.func_72838_d(passenger);
        }
    }

    private void cleanupUnspawnedEntity(Entity entity) {
        if (entity != null) {
            entity.func_70106_y();
            Entity ridingEntity = entity.func_184187_bx();
            if (ridingEntity != null) {
                ridingEntity.func_70106_y();
            }
            for (Entity passenger : entity.func_184188_bt()) {
                passenger.func_70106_y();
            }
        }
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 334) {
            this.needsRedstone = buf.readBoolean();
        }
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.needsRedstone);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.needsRedstone = buf.readBoolean();
    }

    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74757_a("spawnMode", this.spawnMode);
        NBTTagCompound mobTag = this.mobToSpawn == null ? new NBTTagCompound() : this.mobToSpawn.toNbt(null);
        compound.func_74782_a("mobToSpawn", (NBTBase)mobTag);
        return compound;
    }

    public void deserializeNBT(@NotNull NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.spawnMode = compound.func_74767_n("spawnMode");
        this.mobToSpawn = CapturedMob.create((NBTTagCompound)compound.func_74775_l("mobToSpawn"));
    }

    @NotNull
    private ItemStack createSoulVial(@NotNull CapturedMob mobToSpawn) {
        Entity entity = this.createEntity(mobToSpawn);
        if (entity == null) {
            return ItemStack.field_190927_a;
        }
        CapturedMob newMob = CapturedMob.create((Entity)entity);
        this.cleanupUnspawnedEntity(entity);
        if (newMob == null) {
            return ItemStack.field_190927_a;
        }
        return newMob.toStack(ModObject.itemSoulVial.getItemNN(), 1, 1);
    }

    @Nullable
    private Entity createEntity(CapturedMob capturedMob) {
        BlockPos pos;
        World world = this.metaTileEntity.getWorld();
        Entity ent = capturedMob.getEntity(world, pos = this.metaTileEntity.getPos(), world.func_175649_E(pos), false);
        if (ent == null) {
            return null;
        }
        if ((Integer)SpawnerConfig.poweredSpawnerMaxPlayerDistance.get() <= 0 && (Integer)SpawnerConfig.poweredSpawnerDespawnTimeSeconds.get() > 0 && ent instanceof EntityLiving) {
            ent.getEntityData().func_74772_a("spawnedByPoweredSpawner", world.func_82737_E());
            ((EntityLiving)ent).func_110163_bv();
        }
        return ent;
    }

    private boolean isCapturedMobInvalid(CapturedMob capturedMob) {
        if (capturedMob == null) {
            return true;
        }
        Entity entityToSpawn = this.createEntity(capturedMob);
        if (entityToSpawn == null) {
            return true;
        }
        this.cleanupUnspawnedEntity(entityToSpawn);
        return false;
    }
}

