/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.integration.eio.metatileentities;

import com.github.gtexpert.core.api.gui.GTEGuiTextures;
import com.github.gtexpert.core.api.util.GTEUtility;
import com.github.gtexpert.core.common.metatileentities.GTESimpleMachineMetaTileEntity;
import com.github.gtexpert.core.integration.eio.metatileentities.ElectricSpawnerLogic;
import gregtech.api.GTValues;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.capability.impl.RecipeLogicEnergy;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.ItemStackTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.RecipeProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.client.renderer.ICubeRenderer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityElectricSpawner
extends GTESimpleMachineMetaTileEntity {
    private static IGuiTexture spawnEggTexture;
    private static IGuiTexture soulVialTexture;
    private static IGuiTexture redstoneTorchTexture;

    public MetaTileEntityElectricSpawner(ResourceLocation metaTileEntityId, ICubeRenderer renderer, int tier) {
        super(metaTileEntityId, null, renderer, tier, true);
    }

    protected RecipeLogicEnergy createWorkable(RecipeMap<?> recipeMap) {
        return new ElectricSpawnerLogic((MetaTileEntity)this, () -> this.energyContainer);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityElectricSpawner(this.metaTileEntityId, this.renderer, this.getTier());
    }

    protected IItemHandlerModifiable createImportItemHandler() {
        return new NotifiableItemStackHandler((MetaTileEntity)this, 2, (MetaTileEntity)this, false);
    }

    protected IItemHandlerModifiable createExportItemHandler() {
        return new NotifiableItemStackHandler((MetaTileEntity)this, 1, (MetaTileEntity)this, true);
    }

    protected FluidTankList createImportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[0]);
    }

    protected FluidTankList createExportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[0]);
    }

    public boolean hasGhostCircuitInventory() {
        return false;
    }

    public SoundEvent getSound() {
        return null;
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VNF[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        String key = this.metaTileEntityId.func_110623_a().split("\\.")[0];
        String mainKey = String.format("gregtech.machine.%s.tooltip", key);
        if (I18n.func_188566_a((String)mainKey)) {
            tooltip.add(1, mainKey);
        }
    }

    private ElectricSpawnerLogic getLogic() {
        return (ElectricSpawnerLogic)this.workable;
    }

    public String getSpawnModeTranslationKey() {
        return this.getSpawnModeTranslationKey(this.getLogic().getSpawnMode());
    }

    private String getSpawnModeTranslationKey(boolean spawnMode) {
        String mode = spawnMode ? "spawn" : "capture";
        return "gtexpert.gui.electric_spawner_mode." + mode;
    }

    public boolean needsRedstone() {
        return this.getLogic().needsRedstone();
    }

    @Override
    protected ModularUI.Builder createGuiTemplate(EntityPlayer player) {
        if (spawnEggTexture == null) {
            spawnEggTexture = new ItemStackTexture(Items.field_151063_bx, new Item[0]);
        }
        if (soulVialTexture == null) {
            soulVialTexture = new ItemStackTexture(GTEUtility.getModItem("enderio", "item_soul_vial"), new ItemStack[0]);
        }
        if (redstoneTorchTexture == null) {
            redstoneTorchTexture = new ItemStackTexture(new ItemStack(Objects.requireNonNull(Blocks.field_150429_aA)), new ItemStack[0]);
        }
        int yOffset = 0;
        ModularUI.Builder builder = this.createUITemplate(() -> ((AbstractRecipeLogic)this.workable).getProgressPercent(), this.importItems, this.exportItems, yOffset).widget((Widget)new LabelWidget(5, 5, this.getMetaFullName(), new Object[0])).widget((Widget)new SlotWidget((IItemHandler)this.chargerInventory, 0, 79, 62 + yOffset, true, true, false).setBackgroundTexture(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.CHARGER_OVERLAY}).setTooltipText("gregtech.gui.charger_slot.tooltip", new Object[]{GTValues.VNF[this.getTier()], GTValues.VNF[this.getTier()]})).widget((Widget)new ImageWidget(79, 42 + yOffset, 18, 18, (IGuiTexture)GuiTextures.INDICATOR_NO_ENERGY).setIgnoreColor(true).setPredicate(() -> ((AbstractRecipeLogic)this.workable).isHasNotEnoughEnergy())).bindPlayerInventory(player.field_71071_by, (IGuiTexture)GuiTextures.SLOT, yOffset);
        int leftButtonStartX = 7;
        builder.widget((Widget)new ToggleButtonWidget(leftButtonStartX, 62 + yOffset, 18, 18, GuiTextures.BUTTON_ITEM_OUTPUT, () -> ((MetaTileEntityElectricSpawner)this).isAutoOutputItems(), arg_0 -> ((MetaTileEntityElectricSpawner)this).setAutoOutputItems(arg_0)).setTooltipText("gregtech.gui.item_auto_output.tooltip", new Object[0]).shouldUseBaseBackground());
        leftButtonStartX += 18;
        builder.widget((Widget)new CycleButtonWidget(leftButtonStartX, 62 + yOffset, 18, 18, this.workable.getAvailableOverclockingTiers(), () -> ((AbstractRecipeLogic)this.workable).getOverclockTier(), arg_0 -> ((AbstractRecipeLogic)this.workable).setOverclockTier(arg_0)).setTooltipHoverString("gregtech.gui.overclock.description").setButtonTexture(GuiTextures.BUTTON_OVERCLOCK));
        ImageWidget logo = new ImageWidget(152, 63 + yOffset, 17, 17, (IGuiTexture)((Boolean)GTValues.XMAS.get() != false ? GTEGuiTextures.GTE_LOGO_XMAS : GTEGuiTextures.GTE_LOGO)).setIgnoreColor(true);
        builder.widget((Widget)logo);
        builder.widget((Widget)new ToggleButtonWidget(leftButtonStartX += 18, 62 + yOffset, 18, 18, () -> this.getLogic().getSpawnMode(), mode -> this.getLogic().setSpawnMode(mode)){

            public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
                Position pos = this.getPosition();
                Size size = this.getSize();
                GuiTextures.BUTTON_OVERCLOCK.draw((double)pos.x, (double)pos.y, size.width, size.height);
                IGuiTexture overlay = this.isPressed ? spawnEggTexture : soulVialTexture;
                overlay.draw((double)pos.x + 0.5, (double)pos.y + 0.5, size.width - 1, size.height - 1);
            }

            public void drawInForeground(int mouseX, int mouseY) {
                if (!this.isMouseOverElement(mouseX, mouseY)) {
                    return;
                }
                List<String> hoverList = Arrays.asList(LocalizationUtils.formatLines((String)MetaTileEntityElectricSpawner.this.getSpawnModeTranslationKey(), (Object[])new Object[0]));
                this.drawHoveringText(ItemStack.field_190927_a, hoverList, 300, mouseX, mouseY);
            }
        });
        builder.widget((Widget)new ImageWidget(leftButtonStartX += 18, 62 + yOffset, 16, 16){

            public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
                if (!MetaTileEntityElectricSpawner.this.needsRedstone()) {
                    return;
                }
                Position position = this.getPosition();
                Size size = this.getSize();
                redstoneTorchTexture.draw((double)position.x, (double)position.y, size.width, size.height);
            }

            public void drawInForeground(int mouseX, int mouseY) {
                if (!this.isMouseOverElement(mouseX, mouseY) || !MetaTileEntityElectricSpawner.this.needsRedstone()) {
                    return;
                }
                List<String> hoverList = Arrays.asList(LocalizationUtils.formatLines((String)"gtexpert.gui.needs_redstone", (Object[])new Object[0]));
                this.drawHoveringText(ItemStack.field_190927_a, hoverList, 300, mouseX, mouseY);
            }
        });
        return builder;
    }

    private ModularUI.Builder createUITemplate(DoubleSupplier progressSupplier, IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, int yOffset) {
        ModularUI.Builder builder = ModularUI.defaultBuilder((int)yOffset);
        builder.widget((Widget)new RecipeProgressWidget(progressSupplier, 78, 23 + yOffset, 20, 20, GuiTextures.PROGRESS_BAR_ARROW, ProgressWidget.MoveType.HORIZONTAL, null){

            public void drawInForeground(int mouseX, int mouseY) {
            }
        });
        this.addInventorySlotGroup(builder, importItems, false, yOffset);
        this.addInventorySlotGroup(builder, exportItems, true, yOffset);
        return builder;
    }

    private void addInventorySlotGroup(ModularUI.Builder builder, IItemHandlerModifiable itemHandler, boolean isOutputs, int yOffset) {
        boolean wasGroup;
        int itemInputsCount = itemHandler.getSlots();
        int[] inputSlotGrid = MetaTileEntityElectricSpawner.determineSlotsGrid(itemInputsCount);
        int itemSlotsToLeft = inputSlotGrid[0];
        int itemSlotsToDown = inputSlotGrid[1];
        int startInputsX = isOutputs ? 106 : 70 - itemSlotsToLeft * 18;
        int startInputsY = 33 - (int)((double)itemSlotsToDown / 2.0 * 18.0) + yOffset;
        boolean bl = wasGroup = itemHandler.getSlots() == 12;
        if (wasGroup) {
            startInputsY -= 9;
        }
        for (int i = 0; i < itemSlotsToDown; ++i) {
            int slotIndex;
            for (int j = 0; j < itemSlotsToLeft && (slotIndex = i * itemSlotsToLeft + j) < itemInputsCount; ++j) {
                int x = startInputsX + 18 * j;
                int y = startInputsY + 18 * i;
                this.addSlot(builder, x, y, slotIndex, itemHandler, isOutputs);
            }
        }
    }

    private void addSlot(ModularUI.Builder builder, int x, int y, int slotIndex, IItemHandlerModifiable itemHandler, boolean isOutputs) {
        builder.widget((Widget)new SlotWidget((IItemHandler)itemHandler, slotIndex, x, y, true, !isOutputs).setBackgroundTexture((IGuiTexture[])this.getOverlaysForSlot(isOutputs, slotIndex == itemHandler.getSlots() - 1)));
    }

    private TextureArea[] getOverlaysForSlot(boolean isOutput, boolean isLast) {
        TextureArea base = GuiTextures.SLOT;
        TextureArea overlay = !isOutput && isLast ? GTEGuiTextures.SOULVIAL_EMPTY_OVRELAY : GTEGuiTextures.SOULVIAL_FULL_OVERLAY;
        return new TextureArea[]{base, overlay};
    }

    private static int[] determineSlotsGrid(int itemInputsCount) {
        int itemSlotsToLeft;
        int itemSlotsToDown;
        double sqrt = Math.sqrt(itemInputsCount);
        if (sqrt % 1.0 == 0.0) {
            itemSlotsToLeft = itemSlotsToDown = (int)sqrt;
        } else if (itemInputsCount == 3) {
            itemSlotsToLeft = 3;
            itemSlotsToDown = 1;
        } else {
            itemSlotsToLeft = (int)Math.ceil(sqrt);
            if (itemInputsCount > itemSlotsToLeft * (itemSlotsToDown = itemSlotsToLeft - 1)) {
                itemSlotsToDown = itemSlotsToLeft;
            }
        }
        return new int[]{itemSlotsToLeft, itemSlotsToDown};
    }
}

