/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.api;

import com.github.gtexpert.core.api.util.GTELog;
import com.github.gtexpert.core.api.util.Mods;
import com.github.gtexpert.core.integration.ae.AEConfigHolder;
import com.github.gtexpert.core.integration.deda.DEDAConfigHolder;
import com.github.gtexpert.core.integration.eio.EnderIOConfigHolder;

public class GTEValues {
    public static final String MODNAME = "GTExpertCore";
    public static final String MODID = "gtexpert";
    public static int ae2VoltageTier = GTEValues.voltageTier(AEConfigHolder.voltageTier, "ae_integration") ? AEConfigHolder.voltageTier : 3;
    public static int eioVoltageTier = GTEValues.voltageTier(EnderIOConfigHolder.voltageTier, "eio_integration") ? EnderIOConfigHolder.voltageTier : 3;
    public static int dedaVoltageTier = GTEValues.voltageTier(DEDAConfigHolder.voltageTier, "deda_integration") ? DEDAConfigHolder.voltageTier : 6;

    public static boolean isModLoadedDEDA() {
        return Mods.DraconicEvolution.isModLoaded() && Mods.DraconicAdditions.isModLoaded();
    }

    private static boolean voltageTier(int voltage, String mod) {
        String greaterMsg = "Base Voltage must be greater than %d! Set to default value.";
        String lessMsg = "Base Voltage must be less than %d! Set to default value.";
        if (voltage == 0) {
            GTELog.logger.error("{}", (Object)String.format(greaterMsg, 0));
            return false;
        }
        switch (mod) {
            case "ae_integration": {
                if (voltage < 2) {
                    GTELog.logger.error("[ae_integration] {}", (Object)String.format(greaterMsg, 2));
                    break;
                }
                if (voltage > 10) {
                    GTELog.logger.error("[ae_integration] {}", (Object)String.format(lessMsg, 10));
                    break;
                }
                return true;
            }
            case "eio_integration": {
                if (voltage < 1) {
                    GTELog.logger.error("[eio_integration] {}", (Object)String.format(greaterMsg, 1));
                    break;
                }
                if (voltage > 8) {
                    GTELog.logger.error("[eio_integration] {}", (Object)String.format(lessMsg, 8));
                    break;
                }
                return true;
            }
            case "deda_integration": {
                if (voltage < 3) {
                    GTELog.logger.error("[deda_integration] {}", (Object)String.format(greaterMsg, 3));
                    break;
                }
                if (voltage > 6) {
                    GTELog.logger.error("[deda_integration] {}", (Object)String.format(lessMsg, 6));
                    break;
                }
                return true;
            }
            default: {
                GTELog.logger.error("Unknown mod: {}", (Object)mod);
            }
        }
        return false;
    }
}

