/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.common;

import com.github.gtexpert.core.api.unification.material.GTEMaterials;
import com.github.gtexpert.core.common.items.GTEMetaItems;
import gregtech.api.items.armor.ArmorMetaItem;
import gregtech.api.unification.material.event.MaterialEvent;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="gtexpert")
public class GTEEventHandlers {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void registerMaterialsHigh(MaterialEvent event) {
        GTEMaterials.registerMaterialsHigh();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerMaterialsLow(MaterialEvent event) {
        GTEMaterials.registerMaterialsLow();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerMaterialsLowest(MaterialEvent event) {
        GTEMaterials.registerMaterialsLowest();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onEntityLivingFallEvent(@NotNull LivingFallEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            ItemStack armor = player.getItemStackFromSlot(EntityEquipmentSlot.FEET);
            if (player.fallDistance < 3.2f) {
                return;
            }
            if (!armor.isEmpty() && armor.getItem() instanceof ArmorMetaItem && ((ArmorMetaItem.ArmorMetaValueItem)((ArmorMetaItem)armor.getItem()).getItem(armor)).equals(GTEMetaItems.PISTON_BOOTS)) {
                ISpecialArmor.ArmorProperties properties = ((ArmorMetaItem)armor.getItem()).getProperties((EntityLivingBase)player, armor, DamageSource.FALL, (double)((int)player.fallDistance), EntityEquipmentSlot.FEET.getSlotIndex());
                if (properties.AbsorbRatio > 0.0) {
                    event.setCanceled(true);
                    EntityLivingBase entityLivingBase = event.getEntityLiving();
                    PotionEffect potioneffect = event.getEntityLiving().getActivePotionEffect(MobEffects.JUMP_BOOST);
                    float f = potioneffect == null ? 0.0f : (float)(potioneffect.getAmplifier() + 1);
                    int i = MathHelper.ceil((double)((properties.AbsorbRatio - (double)f) * (double)event.getDamageMultiplier()));
                    if (i > 0) {
                        entityLivingBase.attackEntityFrom(DamageSource.FALL, (float)i);
                        int j = MathHelper.floor((double)entityLivingBase.posX);
                        int k = MathHelper.floor((double)(entityLivingBase.posY - (double)0.2f));
                        int l = MathHelper.floor((double)entityLivingBase.posZ);
                        IBlockState iblockstate = entityLivingBase.world.getBlockState(new BlockPos(j, k, l));
                        if (iblockstate.getMaterial() != Material.AIR) {
                            SoundType soundtype = iblockstate.getBlock().getSoundType(iblockstate, entityLivingBase.world, new BlockPos(j, k, l), (Entity)entityLivingBase);
                            entityLivingBase.playSound(soundtype.getFallSound(), soundtype.getVolume() * 0.5f, soundtype.getPitch() * 0.75f);
                        }
                    }
                }
            }
        }
    }
}

