/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.common.metatileentities.multi;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityLargeTransformer
extends MultiblockWithDisplayBase
implements IControllable {
    private EnergyContainerList input = new EnergyContainerList(new ArrayList());
    private ExtendedEnergyContainerList output = new ExtendedEnergyContainerList(new ArrayList<IEnergyContainer>());
    private boolean isWorkingEnabled = true;
    private boolean isActive = true;

    public MetaTileEntityLargeTransformer(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLargeTransformer(this.metaTileEntityId);
    }

    protected void updateFormedValid() {
        if (this.isWorkingEnabled()) {
            long canDrain = this.input.getEnergyStored();
            long totalDrained = this.output.changeEnergy(canDrain);
            this.input.removeEnergy(totalDrained);
        }
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"XSX", "XXX"}).where('X', MetaTileEntityLargeTransformer.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MAINTENANCE_HATCH}).setExactLimit(1).or(MetaTileEntityLargeTransformer.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY}).setExactLimit(1)).or(MetaTileEntityLargeTransformer.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.OUTPUT_ENERGY}).setExactLimit(1)).or(MetaTileEntityLargeTransformer.states((IBlockState[])new IBlockState[]{MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.PALLADIUM_SUBSTATION)}).setExactLimit(2))).where('S', this.selfPredicate()).build();
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        ArrayList powerInput = new ArrayList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        ArrayList<IEnergyContainer> powerOutput = new ArrayList<IEnergyContainer>(this.getAbilities(MultiblockAbility.OUTPUT_ENERGY));
        if (powerInput.isEmpty() || powerOutput.isEmpty()) {
            this.invalidateStructure();
        }
        this.input = new EnergyContainerList(powerInput);
        this.output = new ExtendedEnergyContainerList(powerOutput);
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.input = new EnergyContainerList(new ArrayList());
        this.output = new ExtendedEnergyContainerList(new ArrayList<IEnergyContainer>());
        this.setActive(false);
    }

    protected boolean shouldShowVoidingModeButton() {
        return false;
    }

    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.isWorkingEnabled = isWorkingAllowed;
        this.markDirty();
        World world = this.getWorld();
        if (world != null && !world.isRemote) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(this.isWorkingEnabled));
        }
    }

    public boolean isActive() {
        return super.isActive() && this.isWorkingEnabled;
    }

    public void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.markDirty();
            World world = this.getWorld();
            if (world != null && !world.isRemote) {
                this.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, buf -> buf.writeBoolean(active));
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("isActive", this.isActive);
        data.setBoolean("isWorkingEnabled", this.isWorkingEnabled);
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isActive = data.getBoolean("isActive");
        this.isWorkingEnabled = data.getBoolean("isWorkingEnabled");
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isActive);
        buf.writeBoolean(this.isWorkingEnabled);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isActive = buf.readBoolean();
        this.isWorkingEnabled = buf.readBoolean();
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.isWorkingEnabled = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return (T)super.getCapability(capability, side);
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.PALLADIUM_SUBSTATION_CASING;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.DATA_BANK_OVERLAY;
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), this.isWorkingEnabled());
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed()).setWorkingStatus(true, this.isActive() && this.isWorkingEnabled()).addCustom(tl -> {
            if (this.isStructureFormed()) {
                String inputEnergyFormatted = TextFormattingUtil.formatNumbers((long)this.getInputVolt());
                TextComponentString inputVoltageName = new TextComponentString(GTValues.VNF[GTUtility.getFloorTierByVoltage((long)this.getInputVolt())]);
                TextComponentString inputAmp = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.YELLOW, (String)TextFormattingUtil.formatNumbers((long)this.getInputAmp()));
                tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gtexpert.multiblock.large_transformer.max_input_energy_per_tick_amps", (Object[])new Object[]{inputEnergyFormatted, inputVoltageName, inputAmp}));
                String outputEnergyFormatted = TextFormattingUtil.formatNumbers((long)this.getOutputVolt());
                TextComponentString outputVoltageName = new TextComponentString(GTValues.VNF[GTUtility.getFloorTierByVoltage((long)this.getOutputVolt())]);
                TextComponentString outputAmp = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.YELLOW, (String)TextFormattingUtil.formatNumbers((long)this.getOutputAmp()));
                tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gtexpert.multiblock.large_transformer.max_output_energy_per_tick_amps", (Object[])new Object[]{outputEnergyFormatted, outputVoltageName, outputAmp}));
            }
        }).addWorkingStatusLine();
    }

    protected void addWarningText(List<ITextComponent> textList) {
        super.addWarningText(textList);
        if (this.isStructureFormed() && this.getOutput() > this.getInput()) {
            textList.add((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.YELLOW, (String)"gtexpert.multiblock.large_transformer.not_enough_input", (Object[])new Object[0]));
        }
    }

    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.format((String)"gtexpert.machine.large_transformer.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.format((String)"gtexpert.machine.large_transformer.tooltip.2", (Object[])new Object[0]));
    }

    private long getInput() {
        return this.input.getInputVoltage() * this.input.getInputAmperage();
    }

    private long getOutput() {
        return this.output.getOutputVoltage() * this.output.getOutputAmperage();
    }

    private long getInputAmp() {
        return this.getInput() / this.input.getHighestInputVoltage();
    }

    private long getInputVolt() {
        return this.input.getHighestInputVoltage();
    }

    private long getOutputAmp() {
        return this.getOutput() / this.output.getHighestOutputVoltage();
    }

    private long getOutputVolt() {
        return this.output.getHighestOutputVoltage();
    }

    private static class ExtendedEnergyContainerList
    extends EnergyContainerList {
        private final List<IEnergyContainer> energyContainerList;
        private final long highestOutputVoltage;
        private final int numHighestOutputContainers;

        public ExtendedEnergyContainerList(@NotNull List<IEnergyContainer> energyContainerList) {
            super(energyContainerList);
            this.energyContainerList = energyContainerList;
            long highestOutputVoltage = 0L;
            int numHighestOutputContainers = 0;
            for (IEnergyContainer container : energyContainerList) {
                if (container.getOutputVoltage() <= highestOutputVoltage) continue;
                highestOutputVoltage = container.getOutputVoltage();
            }
            for (IEnergyContainer container : energyContainerList) {
                if (container.getOutputVoltage() != highestOutputVoltage) continue;
                ++numHighestOutputContainers;
            }
            this.highestOutputVoltage = highestOutputVoltage;
            this.numHighestOutputContainers = numHighestOutputContainers;
        }

        public long getHighestOutputVoltage() {
            return this.highestOutputVoltage;
        }

        public int getNumHighestOutputContainers() {
            return this.numHighestOutputContainers;
        }
    }
}

