/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.integration.eio;

import com.enderio.core.common.util.EntityUtil;
import com.github.gtexpert.core.api.modules.GTEModule;
import com.github.gtexpert.core.api.util.GTEUtility;
import com.github.gtexpert.core.integration.GTEIntegrationSubmodule;
import com.github.gtexpert.core.integration.eio.EnderIORecipeMaps;
import com.github.gtexpert.core.integration.eio.loaders.EIOMaterialInfoLoader;
import com.github.gtexpert.core.integration.eio.loaders.EIOOreDictionaryLoader;
import com.github.gtexpert.core.integration.eio.metatileentities.EIOMetaTileEntities;
import com.github.gtexpert.core.integration.eio.recipes.EIOBlocksRecipe;
import com.github.gtexpert.core.integration.eio.recipes.EIOFluidRecipe;
import com.github.gtexpert.core.integration.eio.recipes.EIOItemsRecipe;
import com.github.gtexpert.core.integration.eio.recipes.EIOMaterialsRecipe;
import com.github.gtexpert.core.integration.eio.recipes.EIOSliceNSpliceRecipe;
import com.github.gtexpert.core.integration.eio.recipes.EIOSoulBinderRecipe;
import com.github.gtexpert.core.integration.eio.recipes.EIOToolsRecipe;
import com.github.gtexpert.core.integration.eio.recipes.EIOVialExtractorRecipe;
import crazypants.enderio.base.init.ModObject;
import gregtech.api.GTValues;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.api.recipes.ingredients.nbtmatch.NBTTagType;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

@GTEModule(moduleID="eio_integration", containerID="gtexpert", modDependencies={"enderio"}, name="GTExpert Ender IO Integration", description="Ender IO Integration Module")
public class EnderIOModule
extends GTEIntegrationSubmodule {
    @Override
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        EIOMetaTileEntities.init();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        EIOMaterialsRecipe.remove();
    }

    @Override
    public void registerRecipesNormal(RegistryEvent.Register<IRecipe> event) {
        EIOMaterialInfoLoader.init();
        EIOOreDictionaryLoader.init();
    }

    @Override
    public void registerRecipesLowest(RegistryEvent.Register<IRecipe> event) {
        EIOFluidRecipe.init();
        EIOMaterialsRecipe.init();
        EIOItemsRecipe.init();
        EIOBlocksRecipe.init();
        EIOToolsRecipe.init();
        EIOSliceNSpliceRecipe.init();
        EIOSoulBinderRecipe.init();
        EIOVialExtractorRecipe.init();
    }

    public static void registerVialExtractorRecipe(String entityName, int xpAmount, Consumer<RecipeBuilder<SimpleRecipeBuilder>> applyForRecipeBuilder) {
        if (EnderIOModule.isEntityInvalid(entityName)) {
            return;
        }
        ItemStack stack = new ItemStack(ModObject.itemSoulVial.getItemNN(), 1, 1);
        NBTTagCompound tag = new NBTTagCompound();
        tag.setString("entityId", entityName);
        stack.setTagCompound(tag);
        RecipeBuilder recipeBuilder = EnderIORecipeMaps.VIAL_EXTRACTOR_RECIPES.recipeBuilder();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)recipeBuilder.input(new GTRecipeItemInput(stack).setNBTMatchingCondition(NBTMatcher.RECURSIVE_EQUAL_TO, NBTCondition.create((NBTTagType)NBTTagType.STRING, (String)"entityId", (Object)entityName)))).output(ModObject.itemSoulVial.getItemNN())).fluidOutputs(new FluidStack[]{GTEUtility.getModFluid("xpjuice", xpAmount)});
        applyForRecipeBuilder.accept((RecipeBuilder<SimpleRecipeBuilder>)recipeBuilder);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)recipeBuilder.duration(600)).EUt(GTValues.VA[1])).buildAndRegister();
    }

    public static void registerVialExtractorRecipe(String entityName, int xpAmount, ItemStack ... outputs) {
        EnderIOModule.registerVialExtractorRecipe(entityName, xpAmount, (RecipeBuilder<SimpleRecipeBuilder> builder) -> builder.outputs(outputs));
    }

    public static void registerVialExtractorRecipe(String entityName, ItemStack ... outputs) {
        EnderIOModule.registerVialExtractorRecipe(entityName, 1000, outputs);
    }

    public static boolean isEntityInvalid(ResourceLocation name) {
        return !EntityList.isRegistered((ResourceLocation)name) || !EntityUtil.isRegisteredMob((ResourceLocation)name);
    }

    public static boolean isEntityInvalid(String name) {
        return EnderIOModule.isEntityInvalid(new ResourceLocation(name));
    }
}

