/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.integration.eio.metatileentities;

import com.enderio.core.client.render.BoundingBox;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.soulvial.ItemSoulVial;
import crazypants.enderio.machines.config.config.SpawnerConfig;
import crazypants.enderio.util.CapturedMob;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.RecipeLogicEnergy;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.logic.OverclockingLogic;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElectricSpawnerLogic
extends RecipeLogicEnergy {
    private boolean spawnMode = true;
    private CapturedMob mobToSpawn;
    private boolean needsRedstone = false;

    public ElectricSpawnerLogic(@NotNull MetaTileEntity metaTileEntity, Supplier<IEnergyContainer> energyContainer) {
        super(metaTileEntity, null, energyContainer);
    }

    public boolean getSpawnMode() {
        return this.spawnMode;
    }

    public void setSpawnMode(boolean spawnMode) {
        this.setSpawnModeSilent(spawnMode);
        this.setActive(false);
        this.progressTime = 0;
        this.setMaxProgress(0);
        this.recipeEUt = 0;
        this.setNeedsRedstone(false);
    }

    private void setSpawnModeSilent(boolean spawnMode) {
        this.spawnMode = spawnMode;
    }

    public boolean needsRedstone() {
        return this.needsRedstone;
    }

    private void setNeedsRedstone(boolean needsRedstone) {
        if (this.needsRedstone != needsRedstone) {
            this.needsRedstone = needsRedstone;
            this.writeCustomData(334, buf -> buf.writeBoolean(needsRedstone));
        }
    }

    protected void updateRecipeProgress() {
        if (this.spawnMode && !this.metaTileEntity.isBlockRedstonePowered()) {
            this.setNeedsRedstone(true);
            return;
        }
        this.setNeedsRedstone(false);
        super.updateRecipeProgress();
    }

    protected void completeRecipe() {
        if (this.spawnMode) {
            this.spawnEntities();
        }
        super.completeRecipe();
        this.mobToSpawn = null;
    }

    protected void trySearchNewRecipe() {
        CapturedMob mobToSpawn = this.findMobToSpawn(this.getInputInventory());
        boolean bl = this.invalidInputsForRecipes = mobToSpawn == null;
        if (this.isCapturedMobInvalid(mobToSpawn)) {
            return;
        }
        this.prepareWork(mobToSpawn);
    }

    @Nullable
    private CapturedMob findMobToSpawn(IItemHandlerModifiable inputs) {
        for (int i = 0; i < inputs.getSlots(); ++i) {
            CapturedMob candidate;
            ItemStack stack = inputs.getStackInSlot(i);
            if (!(stack.getItem() instanceof ItemSoulVial) || (candidate = CapturedMob.create((ItemStack)stack)) == null) continue;
            return candidate;
        }
        return null;
    }

    private void prepareWork(@NotNull CapturedMob mobToSpawn) {
        ItemStack outputItem = this.createSoulVial(mobToSpawn);
        if (outputItem.isEmpty()) {
            return;
        }
        if (!this.setupAndConsumeInputs(outputItem)) {
            return;
        }
        this.setup(mobToSpawn, outputItem);
    }

    private boolean setupAndConsumeInputs(@NotNull ItemStack outputItem) {
        if (!this.checkOverclock()) {
            return false;
        }
        if (this.spawnMode) {
            return true;
        }
        if (!this.metaTileEntity.canVoidRecipeItemOutputs() && !GTTransferUtils.addItemsToItemHandler((IItemHandler)this.getOutputInventory(), (boolean)true, Collections.singletonList(outputItem))) {
            this.isOutputsFull = true;
            return false;
        }
        this.isOutputsFull = false;
        return this.consumeEmptyVial();
    }

    private boolean checkOverclock() {
        int eut = 30;
        int duration = 200;
        this.overclockResults = OverclockingLogic.standardOverclockingLogic((int)eut, (long)this.getMaximumOverclockVoltage(), (int)duration, (int)this.getNumberOfOCs(eut), (double)this.getOverclockingDurationDivisor(), (double)this.getOverclockingVoltageMultiplier());
        return this.hasEnoughPower(this.overclockResults);
    }

    private boolean consumeEmptyVial() {
        IItemHandlerModifiable importInventory = this.getInputInventory();
        for (int slot = 0; slot < importInventory.getSlots(); ++slot) {
            ItemStack stack = importInventory.getStackInSlot(slot);
            if (stack.getItem() != ModObject.itemSoulVial.getItemNN() || stack.hasTagCompound()) continue;
            importInventory.extractItem(slot, 1, false);
            return true;
        }
        return false;
    }

    private void setup(@NotNull CapturedMob mobToSpawn, @NotNull ItemStack outputItem) {
        this.progressTime = 1;
        this.setMaxProgress(this.overclockResults[1]);
        this.recipeEUt = this.overclockResults[0];
        this.itemOutputs = !this.spawnMode ? GTUtility.copyStackList(Collections.singletonList(outputItem)) : NonNullList.create();
        this.fluidOutputs = NonNullList.create();
        this.mobToSpawn = mobToSpawn;
        if (this.wasActiveAndNeedsUpdate) {
            this.wasActiveAndNeedsUpdate = false;
        } else {
            this.setActive(true);
        }
    }

    private void spawnEntities() {
        for (int i = 0; i < (Integer)SpawnerConfig.poweredSpawnerSpawnCount.get(); ++i) {
            this.trySpawnEntity(this.mobToSpawn);
        }
    }

    private void trySpawnEntity(CapturedMob mobToSpawn) {
        World world = this.metaTileEntity.getWorld();
        int spawnRange = (Integer)SpawnerConfig.poweredSpawnerSpawnRange.get();
        Class entityClass = mobToSpawn.getEntityClass();
        if (!this.isAreaClear(world, entityClass, spawnRange, 2, (Integer)SpawnerConfig.poweredSpawnerMaxNearbyEntities.get())) {
            return;
        }
        if (entityClass == null || !EntityLiving.class.isAssignableFrom(entityClass)) {
            return;
        }
        BlockPos pos = this.metaTileEntity.getPos();
        EntityLiving entity = (EntityLiving)this.createEntity(mobToSpawn);
        if (entity == null) {
            return;
        }
        for (int i = 0; i < (Integer)SpawnerConfig.poweredSpawnerMaxSpawnTries.get(); ++i) {
            double x = (double)pos.getX() + 0.5 + (world.rand.nextDouble() - world.rand.nextDouble()) * (double)spawnRange;
            double y = pos.getY() + world.rand.nextInt(3) - 1;
            double z = (double)pos.getZ() + 0.5 + (world.rand.nextDouble() - world.rand.nextDouble()) * (double)spawnRange;
            entity.setLocationAndAngles(x, y, z, world.rand.nextFloat() * 360.0f, 0.0f);
            if (!this.canSpawnEntity(entity)) continue;
            world.spawnEntity((Entity)entity);
            world.playEvent(2004, pos, 0);
            entity.spawnExplosionParticle();
            this.addDependents(world, entity);
            return;
        }
        this.cleanupUnspawnedEntity((Entity)entity);
    }

    private boolean isAreaClear(World world, Class<? extends Entity> entityClass, int spawnRangeXZ, int spawnRangeY, int amount) {
        if (amount > 0) {
            return world.getEntitiesWithinAABB(entityClass, (AxisAlignedBB)new BoundingBox(this.metaTileEntity.getPos()).expand((double)spawnRangeXZ, (double)spawnRangeY, (double)spawnRangeXZ), EntitySelectors.IS_ALIVE).size() < amount;
        }
        return true;
    }

    private boolean canSpawnEntity(EntityLiving entityliving) {
        boolean bl;
        switch ((Boolean)SpawnerConfig.poweredSpawnerUseForgeSpawnChecks.get() != false ? ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)entityliving.world, (float)((float)entityliving.posX), (float)((float)entityliving.posY), (float)((float)entityliving.posZ), null) : Event.Result.DEFAULT) {
            case ALLOW: {
                bl = true;
                break;
            }
            case DEFAULT: {
                if (((Boolean)SpawnerConfig.poweredSpawnerUseVanillaSpawnChecks.get()).booleanValue()) {
                    if (entityliving.getCanSpawnHere() && entityliving.isNotColliding()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                bl = entityliving.isNotColliding();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private void addDependents(@NotNull World world, @NotNull EntityLiving entity) {
        Entity ridingEntity = entity.getRidingEntity();
        if (ridingEntity != null) {
            ridingEntity.setLocationAndAngles(entity.posX, entity.posY, entity.posZ, entity.rotationYaw, 0.0f);
            if (!ridingEntity.isAddedToWorld()) {
                world.spawnEntity(ridingEntity);
            }
        }
        for (Entity passenger : entity.getPassengers()) {
            passenger.setLocationAndAngles(entity.posX, entity.posY, entity.posZ, entity.rotationYaw, 0.0f);
            if (passenger.isAddedToWorld()) continue;
            world.spawnEntity(passenger);
        }
    }

    private void cleanupUnspawnedEntity(Entity entity) {
        if (entity != null) {
            entity.setDead();
            Entity ridingEntity = entity.getRidingEntity();
            if (ridingEntity != null) {
                ridingEntity.setDead();
            }
            for (Entity passenger : entity.getPassengers()) {
                passenger.setDead();
            }
        }
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 334) {
            this.needsRedstone = buf.readBoolean();
        }
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.needsRedstone);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.needsRedstone = buf.readBoolean();
    }

    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.setBoolean("spawnMode", this.spawnMode);
        NBTTagCompound mobTag = this.mobToSpawn == null ? new NBTTagCompound() : this.mobToSpawn.toNbt(null);
        compound.setTag("mobToSpawn", (NBTBase)mobTag);
        return compound;
    }

    public void deserializeNBT(@NotNull NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.spawnMode = compound.getBoolean("spawnMode");
        this.mobToSpawn = CapturedMob.create((NBTTagCompound)compound.getCompoundTag("mobToSpawn"));
    }

    @NotNull
    private ItemStack createSoulVial(@NotNull CapturedMob mobToSpawn) {
        Entity entity = this.createEntity(mobToSpawn);
        if (entity == null) {
            return ItemStack.EMPTY;
        }
        CapturedMob newMob = CapturedMob.create((Entity)entity);
        this.cleanupUnspawnedEntity(entity);
        if (newMob == null) {
            return ItemStack.EMPTY;
        }
        return newMob.toStack(ModObject.itemSoulVial.getItemNN(), 1, 1);
    }

    @Nullable
    private Entity createEntity(CapturedMob capturedMob) {
        BlockPos pos;
        World world = this.metaTileEntity.getWorld();
        Entity ent = capturedMob.getEntity(world, pos = this.metaTileEntity.getPos(), world.getDifficultyForLocation(pos), false);
        if (ent == null) {
            return null;
        }
        if ((Integer)SpawnerConfig.poweredSpawnerMaxPlayerDistance.get() <= 0 && (Integer)SpawnerConfig.poweredSpawnerDespawnTimeSeconds.get() > 0 && ent instanceof EntityLiving) {
            ent.getEntityData().setLong("spawnedByPoweredSpawner", world.getTotalWorldTime());
            ((EntityLiving)ent).enablePersistence();
        }
        return ent;
    }

    private boolean isCapturedMobInvalid(CapturedMob capturedMob) {
        if (capturedMob == null) {
            return true;
        }
        Entity entityToSpawn = this.createEntity(capturedMob);
        if (entityToSpawn == null) {
            return true;
        }
        this.cleanupUnspawnedEntity(entityToSpawn);
        return false;
    }
}

