/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.loaders.recipe;

import com.github.gtexpert.core.common.items.GTEMetaItems;
import gregicality.multiblocks.api.fluids.GCYMFluidStorageKeys;
import gregicality.multiblocks.api.unification.properties.GCYMPropertyKey;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.fluids.store.FluidStorageKeys;
import gregtech.api.items.OreDictNames;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.GTRecipeHandler;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.AssemblerRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.category.RecipeCategories;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class CEUOverrideRecipe {
    public static void init() {
        CEUOverrideRecipe.materials();
        CEUOverrideRecipe.items();
        CEUOverrideRecipe.blocks();
        CEUOverrideRecipe.tools();
    }

    private static void materials() {
        ArrayList materials = new ArrayList(GregTechAPI.materialManager.getRegisteredMaterials());
        materials.forEach(CEUOverrideRecipe::vacuumFreezerExtended);
        materials.forEach(CEUOverrideRecipe::removeGem);
        ModHandler.addShapelessRecipe((String)"wrought_iron_nugget", (ItemStack)OreDictUnifier.get((OrePrefix)OrePrefix.nugget, (Material)Materials.Iron, (int)9), (Object[])new Object[]{OreDictUnifier.get((OrePrefix)OrePrefix.ingot, (Material)Materials.Iron, (int)1)});
        ModHandler.addShapelessRecipe((String)"gold_nugget", (ItemStack)OreDictUnifier.get((OrePrefix)OrePrefix.nugget, (Material)Materials.Gold, (int)9), (Object[])new Object[]{OreDictUnifier.get((OrePrefix)OrePrefix.ingot, (Material)Materials.Gold, (int)1)});
        ModHandler.addSmeltingRecipe((ItemStack)OreDictUnifier.get((OrePrefix)OrePrefix.nugget, (Material)Materials.WroughtIron, (int)1), (ItemStack)OreDictUnifier.get((OrePrefix)OrePrefix.nugget, (Material)Materials.WroughtIron, (int)1));
        ModHandler.addShapedRecipe((String)"wrought_iron_ingot", (ItemStack)OreDictUnifier.get((OrePrefix)OrePrefix.ingot, (Material)Materials.WroughtIron, (int)1), (Object[])new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), OreDictUnifier.get((OrePrefix)OrePrefix.nugget, (Material)Materials.WroughtIron, (int)1)});
        ModHandler.addMirroredShapedRecipe((String)"stone_rod", (ItemStack)OreDictUnifier.get((OrePrefix)OrePrefix.stick, (Material)Materials.Stone), (Object[])new Object[]{"s", "S", Character.valueOf('S'), new UnificationEntry(OrePrefix.block, Materials.Stone)});
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.CENTRIFUGE_RECIPES, (ItemStack[])new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Netherrack, (int)1)});
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder()).input(OrePrefix.dust, Materials.Netherrack, 1)).chancedOutput(OrePrefix.dustTiny, Materials.Gold, 620, 120)).chancedOutput(OrePrefix.dustTiny, Materials.Redstone, 5600, 850)).chancedOutput(OrePrefix.dustTiny, Materials.Coal, 5600, 850)).chancedOutput(OrePrefix.dustTiny, Materials.Glowstone, 5600, 850)).chancedOutput(OrePrefix.dust, Materials.Sulfur, 9900, 100)).duration(160)).EUt(20)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder()).circuitMeta(1)).input(OrePrefix.dust, Materials.Iron)).input(OrePrefix.dust, Materials.Sulfur, 2)).output(OrePrefix.dust, Materials.Pyrite, 3)).duration(100)).EUt(GTValues.VA[1])).buildAndRegister();
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.FORGE_HAMMER_RECIPES, (ItemStack[])new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.block, (Material)Materials.EnderPearl)});
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.FORGE_HAMMER_RECIPES, (ItemStack[])new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.block, (Material)Materials.EnderEye)});
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.FLUID_SOLIDFICATION_RECIPES, (ItemStack[])new ItemStack[]{MetaItems.SHAPE_MOLD_PLATE.getStackForm()}, (FluidStack[])new FluidStack[]{Materials.Diamond.getFluid(144)});
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.FLUID_SOLIDFICATION_RECIPES, (ItemStack[])new ItemStack[]{MetaItems.SHAPE_MOLD_GEAR.getStackForm()}, (FluidStack[])new FluidStack[]{Materials.Diamond.getFluid(576)});
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.FLUID_SOLIDFICATION_RECIPES, (ItemStack[])new ItemStack[]{MetaItems.SHAPE_MOLD_BLOCK.getStackForm()}, (FluidStack[])new FluidStack[]{Materials.Diamond.getFluid(1296)});
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder()).circuitMeta(2)).input(OrePrefix.dust, Materials.Silicon)).input(OrePrefix.dust, Materials.Pyrite, 5)).input(OrePrefix.dust, Materials.Ruby)).fluidInputs(new FluidStack[]{Materials.Mercury.getFluid(3000)})).output(OrePrefix.dust, Materials.Redstone, 10)).duration(500)).EUt(GTValues.VA[2])).buildAndRegister();
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.CENTRIFUGE_RECIPES, (ItemStack[])new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Glowstone, (int)2)});
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder()).circuitMeta(1)).fluidInputs(new FluidStack[]{Materials.Redstone.getFluid(144)})).fluidInputs(new FluidStack[]{Materials.Gold.getFluid(144)})).fluidOutputs(new FluidStack[]{Materials.Glowstone.getFluid(288)})).duration(500)).EUt(GTValues.VA[2])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MIXER_RECIPES.recipeBuilder()).circuitMeta(1)).input(OrePrefix.dust, Materials.Redstone)).input(OrePrefix.dust, Materials.Gold)).output(OrePrefix.dust, Materials.Glowstone, 2)).duration(500)).EUt(GTValues.VA[2])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder()).input(OrePrefix.dust, Materials.Glowstone, 2)).output(OrePrefix.dust, Materials.Redstone, 1)).output(OrePrefix.dust, Materials.Gold, 1)).duration(488)).EUt(80)).buildAndRegister();
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.EXTRACTOR_RECIPES, (ItemStack[])new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Ice, (int)1)}, (FluidStack[])new FluidStack[]{Materials.Ice.getFluid(144)});
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.EXTRACTOR_RECIPES, (ItemStack[])new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.block, (Material)Materials.Ice, (int)1)}, (FluidStack[])new FluidStack[]{Materials.Ice.getFluid(144)});
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.FLUID_HEATER_RECIPES, (ItemStack[])new ItemStack[]{IntCircuitIngredient.getIntegratedCircuit((int)1)}, (FluidStack[])new FluidStack[]{Materials.Ice.getFluid(144)});
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.FLUID_SOLIDFICATION_RECIPES, (ItemStack[])new ItemStack[]{MetaItems.SHAPE_MOLD_BLOCK.getStackForm()}, (FluidStack[])new FluidStack[]{Materials.Ice.getFluid(144)});
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder()).input(OrePrefix.dust, Materials.Ice, 1)).fluidOutputs(new FluidStack[]{Materials.Ice.getFluid(1000)})).category(RecipeCategories.EXTRACTOR_RECYCLING)).duration(6)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder()).input(OrePrefix.block, Materials.Ice, 1)).fluidOutputs(new FluidStack[]{Materials.Ice.getFluid(1000)})).category(RecipeCategories.EXTRACTOR_RECYCLING)).duration(6)).EUt(GTValues.VA[1])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_HEATER_RECIPES.recipeBuilder()).circuitMeta(1)).fluidInputs(new FluidStack[]{Materials.Ice.getFluid(1000)})).fluidOutputs(new FluidStack[]{Materials.Water.getFluid(1000)})).duration(32)).EUt(GTValues.VH[0])).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_BLOCK.getStackForm())).fluidInputs(new FluidStack[]{Materials.Ice.getFluid(1000)})).output(OrePrefix.block, Materials.Ice, 1)).duration(6)).EUt(GTValues.VA[0])).buildAndRegister();
    }

    private static void items() {
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.EXTRACTOR_RECIPES, (ItemStack[])new ItemStack[]{new ItemStack(Blocks.BOOKSHELF)});
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder()).input("bookshelf", 1)).outputs(new ItemStack[]{new ItemStack(Items.BOOK, 3)})).category(RecipeCategories.EXTRACTOR_RECYCLING)).duration(300)).EUt(2)).buildAndRegister();
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.ARC_FURNACE_RECIPES, (ItemStack[])new ItemStack[]{new ItemStack(Blocks.BOOKSHELF)}, (FluidStack[])new FluidStack[]{Materials.Oxygen.getFluid(21)});
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ARC_FURNACE_RECIPES.recipeBuilder()).input("bookshelf")).category(RecipeCategories.ARC_FURNACE_RECYCLING)).fluidInputs(new FluidStack[]{Materials.Oxygen.getFluid(21)})).output(OrePrefix.dustTiny, Materials.Ash, 16)).duration(21)).EUt(GTValues.VA[1])).buildAndRegister();
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.MACERATOR_RECIPES, (ItemStack[])new ItemStack[]{new ItemStack(Blocks.BOOKSHELF)});
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder()).input("bookshelf")).output(OrePrefix.dust, Materials.Paper, 9)).output(OrePrefix.dust, Materials.Wood, 6)).category(RecipeCategories.MACERATOR_RECYCLING)).duration(1470)).EUt(2)).buildAndRegister();
    }

    private static void blocks() {
        ModHandler.removeRecipeByOutput((ItemStack)new ItemStack(Blocks.ENCHANTING_TABLE));
        ModHandler.addShapedRecipe((String)"enchantment_table", (ItemStack)new ItemStack(Blocks.ENCHANTING_TABLE), (Object[])new Object[]{"DCD", "PBP", "DPD", Character.valueOf('D'), OreDictUnifier.get((OrePrefix)OrePrefix.gem, (Material)Materials.Diamond), Character.valueOf('C'), new ItemStack(Blocks.CARPET, 1, 14), Character.valueOf('P'), OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Obsidian), Character.valueOf('B'), "bookshelf"});
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.ASSEMBLER_RECIPES, (ItemStack[])new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Redstone, (int)4), OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Glowstone, (int)4)});
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(1)).input(OrePrefix.plate, Materials.Redstone, 4)).input(OrePrefix.plate, Materials.Glowstone, 4)).output(Blocks.REDSTONE_LAMP)).duration(100)).EUt(1)).buildAndRegister();
        if (ConfigHolder.recipes.hardMiscRecipes) {
            for (int i = 0; i < Materials.CHEMICAL_DYES.length; ++i) {
                EnumDyeColor color = EnumDyeColor.byMetadata((int)i);
                String colorName = color.getName().equals("silver") ? "light_gray" : color.getName();
                ModHandler.removeRecipeByOutput((ItemStack)new ItemStack(Blocks.CARPET, 3, i));
                GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.CUTTER_RECIPES, (ItemStack[])new ItemStack[]{new ItemStack(Blocks.WOOL, 2, i)}, (FluidStack[])new FluidStack[]{Materials.Lubricant.getFluid(2)});
                GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.CUTTER_RECIPES, (ItemStack[])new ItemStack[]{new ItemStack(Blocks.WOOL, 2, i)}, (FluidStack[])new FluidStack[]{Materials.DistilledWater.getFluid(3)});
                GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.CUTTER_RECIPES, (ItemStack[])new ItemStack[]{new ItemStack(Blocks.WOOL, 2, i)}, (FluidStack[])new FluidStack[]{Materials.Water.getFluid(4)});
                ModHandler.addMirroredShapedRecipe((String)(colorName + "_wool"), (ItemStack)new ItemStack(Blocks.CARPET, 1, i), (Object[])new Object[]{"WW ", Character.valueOf('W'), new ItemStack(Blocks.WOOL, 1, i)});
                ModHandler.addMirroredShapedRecipe((String)(colorName + "_wool_saw"), (ItemStack)new ItemStack(Blocks.CARPET, 2, i), (Object[])new Object[]{"WWs", Character.valueOf('W'), new ItemStack(Blocks.WOOL, 1, i)});
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{new ItemStack(Blocks.WOOL, 1, i)})).fluidInputs(new FluidStack[]{Materials.Water.getFluid(4)})).outputs(new ItemStack[]{new ItemStack(Blocks.CARPET, 3, i)})).duration(150)).EUt(7)).buildAndRegister();
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{new ItemStack(Blocks.WOOL, 1, i)})).fluidInputs(new FluidStack[]{Materials.DistilledWater.getFluid(3)})).outputs(new ItemStack[]{new ItemStack(Blocks.CARPET, 3, i)})).duration(100)).EUt(7)).buildAndRegister();
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder()).inputs(new ItemStack[]{new ItemStack(Blocks.WOOL, 1, i)})).fluidInputs(new FluidStack[]{Materials.Lubricant.getFluid(1)})).outputs(new ItemStack[]{new ItemStack(Blocks.CARPET, 3, i)})).duration(50)).EUt(7)).buildAndRegister();
            }
        }
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).circuitMeta(2)).input(OrePrefix.plank, Materials.Wood, 4)).input(OreDictNames.chestWood.toString(), 2)).input(OrePrefix.slab, Materials.Wood, 1)).input(Blocks.CRAFTING_TABLE)).output((MetaTileEntity)MetaTileEntities.WORKBENCH)).duration(100)).EUt(GTValues.VH[1])).buildAndRegister();
        ModHandler.addShapedRecipe((boolean)true, (String)"gregtech.machine.battery_buffer.uhv.4", (ItemStack)MetaTileEntities.BATTERY_BUFFER[0][9].getStackForm(), (Object[])new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Europium), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe((boolean)true, (String)"gregtech.machine.battery_buffer.uhv.8", (ItemStack)MetaTileEntities.BATTERY_BUFFER[1][9].getStackForm(), (Object[])new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtOctal, Materials.Europium), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe((boolean)true, (String)"gregtech.machine.battery_buffer.uhv.16", (ItemStack)MetaTileEntities.BATTERY_BUFFER[2][9].getStackForm(), (Object[])new Object[]{"WTW", "WMW", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtHex, Materials.Europium), Character.valueOf('T'), OreDictNames.chestWood});
        ModHandler.addShapedRecipe((boolean)true, (String)"gregtech.machine.turbo_charger.uhv", (ItemStack)MetaTileEntities.CHARGER[9].getStackForm(), (Object[])new Object[]{"QTQ", "QMQ", "WCW", Character.valueOf('M'), MetaTileEntities.HULL[9].getStackForm(), Character.valueOf('Q'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Europium), Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtSingle, Materials.Europium), Character.valueOf('C'), MetaItems.WETWARE_MAINFRAME_UHV, Character.valueOf('T'), OreDictNames.chestWood});
    }

    private static void tools() {
        ModHandler.addShapedRecipe((String)"nano_boots_from_piston_boots", (ItemStack)MetaItems.NANO_BOOTS.getStackForm(), (Object[])new Object[]{"PBP", "xEd", Character.valueOf('B'), GTEMetaItems.PISTON_BOOTS.getStackForm(), Character.valueOf('P'), MetaItems.CARBON_FIBER_PLATE.getStackForm(), Character.valueOf('E'), MetaItems.ENERGIUM_CRYSTAL.getStackForm()});
    }

    private static void vacuumFreezerExtended(@NotNull Material material) {
        int vacuumDuration;
        if (!material.hasProperty(GCYMPropertyKey.ALLOY_BLAST)) {
            return;
        }
        Fluid molten = material.getFluid(GCYMFluidStorageKeys.MOLTEN);
        if (molten == null) {
            return;
        }
        BlastProperty property = (BlastProperty)material.getProperty(PropertyKey.BLAST);
        int vacuumEUt = property.getVacuumEUtOverride() != -1 ? property.getVacuumEUtOverride() : GTValues.VA[2];
        int n = vacuumDuration = property.getVacuumDurationOverride() != -1 ? property.getVacuumDurationOverride() : (int)material.getMass() * 3;
        if (property.getBlastTemperature() >= 5000) {
            if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_PLATE)).fluidInputs(new FluidStack[]{new FluidStack(molten, 144)})).fluidInputs(new FluidStack[]{Materials.Helium.getFluid(FluidStorageKeys.LIQUID, 500)})).fluidOutputs(new FluidStack[]{Materials.Helium.getFluid(250)})).output(OrePrefix.plate, material, 1)).duration(vacuumDuration)).EUt(vacuumEUt)).buildAndRegister();
            }
            if (material.hasFlag(MaterialFlags.GENERATE_SMALL_GEAR)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_GEAR_SMALL)).fluidInputs(new FluidStack[]{new FluidStack(molten, 144)})).fluidInputs(new FluidStack[]{Materials.Helium.getFluid(FluidStorageKeys.LIQUID, 500)})).fluidOutputs(new FluidStack[]{Materials.Helium.getFluid(250)})).output(OrePrefix.gearSmall, material, 1)).duration(vacuumDuration)).EUt(vacuumEUt)).buildAndRegister();
            }
            if (material.hasFlag(MaterialFlags.GENERATE_GEAR)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_GEAR)).fluidInputs(new FluidStack[]{new FluidStack(molten, 576)})).fluidInputs(new FluidStack[]{Materials.Helium.getFluid(FluidStorageKeys.LIQUID, 2000)})).fluidOutputs(new FluidStack[]{Materials.Helium.getFluid(1000)})).output(OrePrefix.gear, material, 1)).duration(vacuumDuration * 4)).EUt(vacuumEUt)).buildAndRegister();
            }
            if (material.hasFlag(MaterialFlags.GENERATE_ROTOR)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_ROTOR)).fluidInputs(new FluidStack[]{new FluidStack(molten, 576)})).fluidInputs(new FluidStack[]{Materials.Helium.getFluid(FluidStorageKeys.LIQUID, 2000)})).fluidOutputs(new FluidStack[]{Materials.Helium.getFluid(1000)})).output(OrePrefix.rotor, material, 1)).duration(vacuumDuration * 4)).EUt(vacuumEUt)).buildAndRegister();
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).circuitMeta(1)).fluidInputs(new FluidStack[]{new FluidStack(molten, 144)})).fluidInputs(new FluidStack[]{Materials.Helium.getFluid(FluidStorageKeys.LIQUID, 500)})).fluidOutputs(new FluidStack[]{Materials.Helium.getFluid(250)})).fluidOutputs(new FluidStack[]{material.getFluid(144)})).duration(vacuumDuration)).EUt(vacuumEUt)).buildAndRegister();
        } else {
            if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_PLATE)).fluidInputs(new FluidStack[]{new FluidStack(molten, 144)})).output(OrePrefix.plate, material, 1)).duration(vacuumDuration)).EUt(vacuumEUt)).buildAndRegister();
            }
            if (material.hasFlag(MaterialFlags.GENERATE_SMALL_GEAR)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_GEAR_SMALL)).fluidInputs(new FluidStack[]{new FluidStack(molten, 144)})).output(OrePrefix.gearSmall, material, 1)).duration(vacuumDuration)).EUt(vacuumEUt)).buildAndRegister();
            }
            if (material.hasFlag(MaterialFlags.GENERATE_GEAR)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_GEAR)).fluidInputs(new FluidStack[]{new FluidStack(molten, 576)})).output(OrePrefix.gear, material, 1)).duration(vacuumDuration * 4)).EUt(vacuumEUt)).buildAndRegister();
            }
            if (material.hasFlag(MaterialFlags.GENERATE_ROTOR)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).notConsumable(MetaItems.SHAPE_MOLD_ROTOR)).fluidInputs(new FluidStack[]{new FluidStack(molten, 576)})).output(OrePrefix.rotor, material, 1)).duration(vacuumDuration * 4)).EUt(vacuumEUt)).buildAndRegister();
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder()).circuitMeta(1)).fluidInputs(new FluidStack[]{new FluidStack(molten, 144)})).fluidOutputs(new FluidStack[]{material.getFluid(144)})).duration(vacuumDuration)).EUt(vacuumEUt)).buildAndRegister();
        }
    }

    private static void removeGem(Material material) {
        if (!material.hasProperty(PropertyKey.FLUID)) {
            return;
        }
        if (!material.hasProperty(PropertyKey.GEM)) {
            return;
        }
        if (!ConfigHolder.recipes.disableManualCompression) {
            return;
        }
        long materialAmount = OrePrefix.block.getMaterialAmount(material);
        GTRecipeHandler.removeRecipesByInputs((RecipeMap)RecipeMaps.FLUID_SOLIDFICATION_RECIPES, (ItemStack[])new ItemStack[]{MetaItems.SHAPE_MOLD_BLOCK.getStackForm()}, (FluidStack[])new FluidStack[]{((FluidProperty)material.getProperty(PropertyKey.FLUID)).solidifiesFrom((int)(materialAmount * 144L / 3628800L))});
    }
}

