/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core;

import com.github.gtexpert.core.api.util.GTELog;
import com.github.gtexpert.core.common.GTEConfigHolder;
import com.github.gtexpert.core.common.items.behaviors.GTECoverBehaviors;
import com.github.gtexpert.core.modules.GTEModuleManager;
import com.github.gtexpert.core.modules.GTEModules;
import com.google.common.collect.ImmutableList;
import gregtech.api.GregTechAPI;
import gregtech.api.cover.CoverDefinition;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="gtexpert", name="GTExpertCore", acceptedMinecraftVersions="[1.12.2]", version="2.5.1-alpha", updateJSON="https://forge.curseupdate.com/851103/gtexpert", dependencies="required-after:gregtech@[2.8.10-beta,);required-after:mixinbooter@[10.5,);required-after:gcym;required-after:appliedenergistics2@[v0.56.7,);after:gtwp;after:inb;after:gregtechfoodoption;after:aeadditions;after:ae2fc;after:nae2;after:extracpus;after:endercore;after:enderio;after:enderioendergy;after:enderiomachines;after:enderioconduits;after:enderioconduitsappliedenergistics;after:draconicevolution;after:draconicadditions;after:chisel;after:avaritia;after:thaumcraft;after:haumicenergistics;")
@Mod.EventBusSubscriber(modid="gtexpert")
public class GTExpertMod {
    private GTEModuleManager moduleManager;

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        GTELog.logger.info("starting construction event...");
        this.moduleManager = GTEModuleManager.getInstance();
        this.moduleManager.registerContainer(new GTEModules());
        this.moduleManager.setup(event.getASMHarvestedData(), Loader.instance().getConfigDir());
        this.moduleManager.onConstruction(event);
        GTELog.logger.info("finished construction!");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.moduleManager.onPreInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.moduleManager.onInit(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.moduleManager.onPostInit(event);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        this.moduleManager.onLoadComplete(event);
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        this.moduleManager.onServerAboutToStart(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.moduleManager.onServerStarting(event);
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        this.moduleManager.onServerStarted(event);
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        this.moduleManager.onServerStopping(event);
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        this.moduleManager.onServerStopped(event);
    }

    @Mod.EventHandler
    public void respondIMC(FMLInterModComms.IMCEvent event) {
        this.moduleManager.processIMC((ImmutableList<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        GTELog.logger.info("Registering Blocks...");
        this.moduleManager.registerBlocks(event);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        GTELog.logger.info("Registering Items...");
        this.moduleManager.registerItems(event);
    }

    @SubscribeEvent
    public static void registerCovers(GregTechAPI.RegisterEvent<CoverDefinition> event) {
        GTELog.logger.info("Registering Covers...");
        String componentsName = GTEConfigHolder.gteFlag.componentsName;
        if (componentsName.equals("ulv") || componentsName.equals("primitive")) {
            GTECoverBehaviors.init();
        } else {
            GTELog.logger.error("Invalid componentsName setting: {}", (Object)componentsName, (Object)new Throwable());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void registerRecipesHighest(RegistryEvent.Register<IRecipe> event) {
        this.moduleManager.registerRecipesHighest(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void registerRecipesHigh(RegistryEvent.Register<IRecipe> event) {
        this.moduleManager.registerRecipesHigh(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        this.moduleManager.registerRecipesNormal(event);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void registerRecipesLow(RegistryEvent.Register<IRecipe> event) {
        this.moduleManager.registerRecipesLow(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerRecipesLowest(RegistryEvent.Register<IRecipe> event) {
        this.moduleManager.registerRecipesLowest(event);
    }

    public static <T extends Block> ItemBlock createItemBlock(T block, Function<T, ItemBlock> producer) {
        ItemBlock itemBlock = producer.apply(block);
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            GTELog.logger.error("Block has no registry name: {}", (Object)block.func_149739_a(), (Object)new Throwable());
        } else {
            itemBlock.setRegistryName(registryName);
        }
        return itemBlock;
    }

    @SubscribeEvent
    public static void syncConfigValues(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("gtexpert")) {
            ConfigManager.sync((String)"gtexpert", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

