/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.common.metatileentities.multi;

import com.github.gtexpert.core.api.gui.GTEGuiTextures;
import com.github.gtexpert.core.api.recipes.GTERecipeMaps;
import com.github.gtexpert.core.client.GTETextures;
import com.github.gtexpert.core.common.GTEConfigHolder;
import com.github.gtexpert.core.common.blocks.GTEBlockMetalCasing;
import com.github.gtexpert.core.common.blocks.GTEMetaBlocks;
import gregicality.multiblocks.api.metatileentity.GCYMRecipeMapMultiblockController;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityLargeGasCollector
extends GCYMRecipeMapMultiblockController {
    public MetaTileEntityLargeGasCollector(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, new RecipeMap[]{RecipeMaps.GAS_COLLECTOR_RECIPES, GTERecipeMaps.LARGE_GAS_COLLECTOR_RECIPES});
    }

    @NotNull
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLargeGasCollector(this.metaTileEntityId);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        TraceabilityPredicate casing = MetaTileEntityLargeGasCollector.states((IBlockState[])new IBlockState[]{this.getCasingState()}).setMinGlobalLimited(8);
        TraceabilityPredicate abilities = this.autoAbilities(true, true, true, true, true, true, false);
        return FactoryBlockPattern.start().aisle(new String[]{"XXX", "XXX", "XXX"}).aisle(new String[]{"XTX", "X#X", "XHX"}).aisle(new String[]{"XXX", "XSX", "XXX"}).where('S', this.selfPredicate()).where('X', casing.or(abilities)).where('T', MetaTileEntityLargeGasCollector.tieredCasing().or(casing)).where('H', MetaTileEntityLargeGasCollector.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH})).where('#', MetaTileEntityLargeGasCollector.air()).build();
    }

    public boolean allowsExtendedFacing() {
        return false;
    }

    public boolean allowsFlip() {
        return false;
    }

    public boolean isTiered() {
        return true;
    }

    public boolean canBeDistinct() {
        return true;
    }

    public boolean isParallel() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return GTETextures.VOID_ORE_MINER_CASING;
    }

    protected IBlockState getCasingState() {
        return GTEMetaBlocks.GTE_METAL_CASING.getState(GTEBlockMetalCasing.MetalCasingType.VOID_ORE_MINER);
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)(GTEConfigHolder.gteFlag.featureFlag ? "gtexpert.machine.large_gas_collector.tooltip.1" : "gtexpert.machine.advanced_gas_collector.tooltip.1"), (Object[])new Object[0]));
    }

    @NotNull
    protected TextureArea getLogo() {
        return GTEGuiTextures.GTE_LOGO_DARK;
    }

    @NotNull
    protected TextureArea getWarningLogo() {
        return GTEGuiTextures.GTE_LOGO_BLINKING_YELLOW;
    }

    @NotNull
    protected TextureArea getErrorLogo() {
        return GTEGuiTextures.GTE_LOGO_BLINKING_RED;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.GAS_COLLECTOR_OVERLAY;
    }
}

