/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.common.metatileentities.multi;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.github.gtexpert.core.api.capability.impl.VoidFluidPumpLogic;
import com.github.gtexpert.core.api.gui.GTEGuiTextures;
import com.github.gtexpert.core.api.unification.material.GTEMaterials;
import com.github.gtexpert.core.client.GTETextures;
import com.github.gtexpert.core.common.GTEConfigHolder;
import com.github.gtexpert.core.common.blocks.GTEBlockMetalCasing;
import com.github.gtexpert.core.common.blocks.GTEMetaBlocks;
import com.google.common.collect.Lists;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.IWorkable;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.IProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.unification.material.Material;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinHandler;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityVoidFluidPump
extends MultiblockWithDisplayBase
implements IWorkable,
IProgressBarMultiblock {
    private final VoidFluidPumpLogic minerLogic = new VoidFluidPumpLogic(this);
    protected IMultipleTankHandler inputFluidInventory;
    protected IMultipleTankHandler outputFluidInventory;
    protected IEnergyContainer energyContainer;

    public MetaTileEntityVoidFluidPump(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityVoidFluidPump(this.metaTileEntityId);
    }

    protected void initializeAbilities() {
        this.inputFluidInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.outputFluidInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
        this.energyContainer = new EnergyContainerList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
    }

    private void resetTileAbilities() {
        this.inputFluidInventory = new FluidTankList(true, new IFluidTank[0]);
        this.outputFluidInventory = new FluidTankList(true, new IFluidTank[0]);
        this.energyContainer = new EnergyContainerList((List)Lists.newArrayList());
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.resetTileAbilities();
    }

    protected void updateFormedValid() {
        this.minerLogic.performDrilling();
        if (!this.getWorld().field_72995_K && this.minerLogic.wasActiveAndNeedsUpdate()) {
            this.minerLogic.setWasActiveAndNeedsUpdate(false);
            this.minerLogic.setActive(false);
        }
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"XXXXXXX", "****F**", "****F**", "****F**"}).aisle(new String[]{"XXXXHXX", "F*****F", "F*****F", "FFFFFFF"}).aisle(new String[]{"XXXXHXX", "*******", "*******", "****F**"}).aisle(new String[]{"XXXXHXX", "F*****F", "F*****F", "FFFFFFF"}).aisle(new String[]{"SXXXXXX", "****F**", "****F**", "****F**"}).where('S', this.selfPredicate()).where('X', MetaTileEntityVoidFluidPump.states((IBlockState[])new IBlockState[]{GTEMetaBlocks.GTE_METAL_CASING.getState(GTEBlockMetalCasing.MetalCasingType.VOID_ORE_MINER)}).or(MetaTileEntityVoidFluidPump.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY}).setExactLimit(1)).or(this.autoAbilities(true, false))).where('F', MetaTileEntityVoidFluidPump.frames((Material[])new Material[]{GTEMaterials.NM_HEA_NPs})).where('H', MetaTileEntityVoidFluidPump.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_FLUIDS}).setExactLimit(1).or(MetaTileEntityVoidFluidPump.states((IBlockState[])new IBlockState[]{GTEMetaBlocks.GTE_METAL_CASING.getState(GTEBlockMetalCasing.MetalCasingType.VOID_ORE_MINER)}))).where('*', MetaTileEntityVoidFluidPump.any()).build();
    }

    protected boolean shouldShowVoidingModeButton() {
        return false;
    }

    public boolean allowsExtendedFacing() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return GTETextures.VOID_ORE_MINER_CASING;
    }

    @NotNull
    protected TextureArea getLogo() {
        return GTEGuiTextures.GTE_LOGO_DARK;
    }

    @NotNull
    protected TextureArea getWarningLogo() {
        return GTEGuiTextures.GTE_LOGO_BLINKING_YELLOW;
    }

    @NotNull
    protected TextureArea getErrorLogo() {
        return GTEGuiTextures.GTE_LOGO_BLINKING_RED;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.FLUID_VOIDING_ADVANCED;
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed()).setWorkingStatus(this.minerLogic.isWorkingEnabled(), this.minerLogic.isActive()).setWorkingStatusKeys("gregtech.multiblock.idling", "gregtech.multiblock.work_paused", "gregtech.multiblock.miner.drilling").addEnergyUsageLine(this.energyContainer).addCustom(tl -> {
            if (this.isStructureFormed()) {
                if (this.minerLogic.getDrilledFluid() != null) {
                    Fluid drilledFluid = this.minerLogic.getDrilledFluid();
                    ITextComponent fluidInfo = TextComponentUtil.setColor((ITextComponent)GTUtility.getFluidTranslation((Fluid)drilledFluid), (TextFormatting)TextFormatting.GREEN);
                    tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.fluid_rig.drilled_fluid", (Object[])new Object[]{fluidInfo}));
                    TextComponentString amountInfo = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.BLUE, (String)(TextFormattingUtil.formatNumbers((long)((long)this.minerLogic.getFluidToProduce() * 20L / 20L)) + " L/s"));
                    tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.fluid_rig.fluid_amount", (Object[])new Object[]{amountInfo}));
                } else {
                    TextComponentTranslation noFluid = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.RED, (String)"gregtech.multiblock.fluid_rig.no_fluid_in_area", (Object[])new Object[0]);
                    tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.fluid_rig.drilled_fluid", (Object[])new Object[]{noFluid}));
                }
            }
        }).addWorkingStatusLine().addProgressLine(this.minerLogic.getProgressPercent());
    }

    protected void addWarningText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed(), (boolean)false).addLowPowerLine(this.isStructureFormed() && !this.drainEnergy(true)).addCustom(tl -> {
            if (this.isStructureFormed() && this.minerLogic.isInventoryFull()) {
                tl.add(TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.YELLOW, (String)"gregtech.machine.miner.invfull", (Object[])new Object[0]));
            }
        });
    }

    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gtexpert.machine.void_fluid_pump.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_drilling_rig.description", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_drilling_rig.depletion", (Object[])new Object[]{TextFormattingUtil.formatNumbers((long)0L)}));
        tooltip.add(I18n.func_135052_a((String)"gtexpert.machine.void_fluid_pump.tooltip.2", (Object[])new Object[]{GTValues.VNF[this.getBaseTier()], this.getBaseMultiplier()}));
        tooltip.add(I18n.func_135052_a((String)"gtexpert.machine.void_fluid_pump.tooltip.3", (Object[])new Object[0]));
    }

    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    public int getBaseTier() {
        return GTEConfigHolder.gteFlag.vfpBaseVoltage;
    }

    public int getBaseMultiplier() {
        return GTEConfigHolder.gteFlag.vfpBaseProductionRate;
    }

    public int getRigMultiplier() {
        return Math.max(1, this.getBaseMultiplier() * (this.getEnergyTier() - this.getBaseTier()));
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.minerLogic.isActive(), this.minerLogic.isWorkingEnabled());
    }

    public boolean isWorkingEnabled() {
        return this.minerLogic.isWorkingEnabled();
    }

    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.minerLogic.setWorkingEnabled(isActivationAllowed);
    }

    public boolean fillTanks(FluidStack stack, boolean simulate) {
        return GTTransferUtils.addFluidsToFluidHandler((IMultipleTankHandler)this.outputFluidInventory, (boolean)simulate, Collections.singletonList(stack));
    }

    public int getEnergyTier() {
        if (this.energyContainer == null) {
            return this.getBaseTier();
        }
        return Math.max(this.getBaseTier(), GTUtility.getFloorTierByVoltage((long)this.energyContainer.getInputVoltage()));
    }

    public long getEnergyInputPerSecond() {
        return this.energyContainer.getInputPerSec();
    }

    public boolean drainEnergy(boolean simulate) {
        long energyToDrain = GTValues.VA[this.getEnergyTier()];
        long resultEnergy = this.energyContainer.getEnergyStored() - energyToDrain;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.changeEnergy(-energyToDrain);
            }
            return true;
        }
        return false;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        return this.minerLogic.writeToNBT(data);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.minerLogic.readFromNBT(data);
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        this.minerLogic.writeInitialSyncData(buf);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.minerLogic.receiveInitialSyncData(buf);
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        this.minerLogic.receiveCustomData(dataId, buf);
    }

    public int getProgress() {
        return this.minerLogic.getProgressTime();
    }

    public int getMaxProgress() {
        return 20;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_WORKABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_WORKABLE.cast((Object)this);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return (T)super.getCapability(capability, side);
    }

    public boolean showProgressBar() {
        return true;
    }

    public double getFillPercentage(int index) {
        int numOperationsLeft = BedrockFluidVeinHandler.getOperationsRemaining((World)this.getWorld(), (int)this.minerLogic.getChunkX(), (int)this.minerLogic.getChunkZ());
        int maxOperations = 100000;
        return 1.0 * (double)numOperationsLeft / (double)maxOperations;
    }

    public TextureArea getProgressBarTexture(int index) {
        return GuiTextures.PROGRESS_BAR_FLUID_RIG_DEPLETION;
    }

    public void addBarHoverText(List<ITextComponent> hoverList, int index) {
        TextFormatting color;
        int maxOperations;
        int numOperationsLeft = BedrockFluidVeinHandler.getOperationsRemaining((World)this.getWorld(), (int)this.minerLogic.getChunkX(), (int)this.minerLogic.getChunkZ());
        int percentage = (int)Math.round(1.0 * (double)numOperationsLeft / (double)(maxOperations = 100000) * 100.0);
        TextFormatting textFormatting = percentage > 40 ? TextFormatting.GREEN : (color = percentage > 10 ? TextFormatting.YELLOW : TextFormatting.RED);
        if (numOperationsLeft == 0) {
            hoverList.add((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.RED, (String)"gregtech.multiblock.fluid_rig.vein_depleted", (Object[])new Object[0]));
        } else {
            TextComponentString veinInfo = TextComponentUtil.stringWithColor((TextFormatting)color, (String)(percentage + "%"));
            hoverList.add((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.fluid_rig.vein_depletion", (Object[])new Object[]{veinInfo}));
        }
    }
}

