/*
 * Decompiled with CFR 0.152.
 */
package de.deinname.extendedinventory;

import de.deinname.extendedinventory.InventoryButton;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryStorage {
    private final File folder;

    public InventoryStorage(File dataFolder) {
        this.folder = new File(dataFolder, "inventories");
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
    }

    public void saveInventory(UUID uuid, int page, Inventory inv) {
        File file = new File(this.folder, String.valueOf(uuid) + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("page" + page, (Object)inv.getContents());
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Inventory loadInventory(UUID uuid, int page) {
        File file = new File(this.folder, String.valueOf(uuid) + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)("Inventory Page" + page));
        ItemStack[] contents = (ItemStack[])config.get("page" + page);
        if (contents != null) {
            inv.setContents(contents);
        }
        inv.setItem(53, InventoryButton.getSwitchButton(page));
        return inv;
    }
}

