/*
 * Decompiled with CFR 0.152.
 */
package com.holebois.map_png;

import com.holebois.map_png.mixin.client.MapRendererInvoker;
import com.holebois.map_png.mixin.client.MapTextureAccessor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_10093;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_239;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_3966;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class MapPngClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"map_png");
    private static final class_304.class_11900 MAP_PNG_KEY_CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60654((String)"map_png"));
    private static final class_304 download_key = new class_304("key.map_png.download", class_3675.class_307.field_1668, 297, MAP_PNG_KEY_CATEGORY);

    public static void showToast(class_2561 title, class_2561 msg) {
        new Thread(() -> {
            try {
                class_370 t = new class_370(class_370.class_9037.field_47585, title, msg);
                class_310.method_1551().method_1566().method_1999((class_368)t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void downloadMap(class_22 mapState, class_9209 mapId) {
        class_310 client = class_310.method_1551();
        class_10093.class_331 texture = ((MapRendererInvoker)client.method_61963()).invokeGetMapTexture(mapId, mapState);
        File save_dir = new File(client.field_1697, "maps");
        if (client.method_1542()) {
            save_dir = new File(save_dir, "singleplayer");
            save_dir = new File(save_dir, client.method_1576().method_27050(class_5218.field_24188).getParent().getFileName().toString());
        } else {
            save_dir = new File(save_dir, "multiplayer");
            save_dir = new File(save_dir, client.method_1558().field_3761.replace(":", "_"));
        }
        if (!save_dir.exists() && !save_dir.mkdirs()) {
            LOGGER.error("Could not create directory " + save_dir.getAbsolutePath() + " cannot continue!");
            return;
        }
        File mapfile = new File(save_dir, "map_" + mapId.comp_2315() + ".png");
        try {
            Optional<class_1043> backing_texture = Optional.ofNullable(((MapTextureAccessor)texture).getTexture());
            if (backing_texture.isEmpty()) {
                Field atlasf = class_10093.class_331.class.getDeclaredField("immediatelyFast$atlasTexture");
                atlasf.setAccessible(true);
                Object atlas = atlasf.get(texture);
                Field atlasx = class_10093.class_331.class.getDeclaredField("immediatelyFast$atlasX");
                atlasx.setAccessible(true);
                int x = (Integer)atlasx.get(texture);
                Field atlasy = class_10093.class_331.class.getDeclaredField("immediatelyFast$atlasY");
                atlasy.setAccessible(true);
                int y = (Integer)atlasy.get(texture);
                Method getTextureMethod = atlas.getClass().getDeclaredMethod("getTexture", new Class[0]);
                class_1043 back = (class_1043)getTextureMethod.invoke(atlas, new Object[0]);
                class_1011 img = new class_1011(128, 128, true);
                back.method_4525().method_47594(img, x, y, 0, 0, 128, 128, false, false);
                img.method_4325(mapfile);
                img.close();
            } else {
                backing_texture.get().method_4525().method_4325(mapfile);
            }
            class_5250 text = class_2561.method_43470((String)mapfile.getName()).method_27695(new class_124[]{class_124.field_1073, class_124.field_1060}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10607(mapfile.getAbsolutePath())));
            client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"map_png.success", (Object[])new Object[]{text}), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            MapPngClient.showToast((class_2561)class_2561.method_43471((String)"map_png.error.title"), (class_2561)class_2561.method_43471((String)"map_png.error.msg"));
        }
    }

    public static class_9209 getMapId(class_1799 stack) {
        return (class_9209)stack.method_58694(class_9334.field_49646);
    }

    public void onInitializeClient() {
        KeyBindingHelper.registerKeyBinding((class_304)download_key);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (download_key.method_1436()) {
                class_1533 frame;
                class_1799 map;
                class_3966 entityHit;
                class_1799 held = client.field_1724.method_6047();
                if (held.method_7909() == class_1802.field_8204) {
                    class_22 mapState = class_1806.method_8001((class_1799)held, (class_1937)client.field_1687);
                    this.downloadMap(mapState, MapPngClient.getMapId(held));
                    return;
                }
                class_239 hit = client.field_1765;
                if (hit.method_17783() == class_239.class_240.field_1331 && (entityHit = (class_3966)hit).method_17782() instanceof class_1533 && (map = (frame = (class_1533)entityHit.method_17782()).method_6940()).method_7909() == class_1802.field_8204) {
                    class_22 mapState = class_1806.method_8001((class_1799)map, (class_1937)client.field_1687);
                    this.downloadMap(mapState, frame.method_43272(map));
                    return;
                }
                MapPngClient.showToast((class_2561)class_2561.method_43471((String)"map_png.invalid_target.title"), (class_2561)class_2561.method_43471((String)"map_png.invalid_target.msg"));
            }
        });
        LOGGER.info("map_png client initialized!");
    }
}

