/*
 * Decompiled with CFR 0.152.
 */
package io.github.zygzaggaming.hearty.mod;

import io.github.zygzaggaming.hearty.api.HeartContext;
import io.github.zygzaggaming.hearty.api.HeartLayer;
import io.github.zygzaggaming.hearty.api.HeartyRegistries;
import io.github.zygzaggaming.hearty.mod.HeartyMain;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.registries.DeferredRegister;

public class HeartLayerRegistry {
    public static final DeferredRegister<HeartLayer> REGISTER = DeferredRegister.create((ResourceKey)HeartyRegistries.HEART_LAYER_KEY, (String)"hearty");
    public static final Supplier<HeartLayer> HEART_WIGGLE = HeartLayerRegistry.register("heart_wiggle", 1.0, ctx -> {
        int y = ctx.y();
        if (ctx.player().getHealth() + ctx.player().getAbsorptionAmount() <= 4.0f) {
            y += ctx.gui().random.nextInt(2);
        }
        if (ctx.heartIndex() == ctx.regenHeartWiggle() || ctx.heartIndex() == ctx.regenHeartWiggle() - 1) {
            y -= 2;
        }
        return ctx.withY(y);
    });

    public static Supplier<HeartLayer> register(String id, double priority, final Function<HeartContext, HeartContext> apply) {
        return REGISTER.register(id, () -> new HeartLayer(HeartyMain.loc(id), priority){

            public HeartContext apply(HeartContext ctx) {
                return (HeartContext)apply.apply(ctx);
            }
        });
    }
}

