/*
 * Decompiled with CFR 0.152.
 */
package io.github.zygzaggaming.hearty.mod;

import io.github.zygzaggaming.hearty.api.HalfHeartContext;
import io.github.zygzaggaming.hearty.api.HalfHeartLayer;
import io.github.zygzaggaming.hearty.mod.HeartTypeRegistry;
import io.github.zygzaggaming.hearty.mod.HeartyMain;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.neoforged.neoforge.registries.DeferredRegister;

public class HalfHeartLayerRegistry {
    public static final ResourceKey<Registry<HalfHeartLayer>> HALF_HEART_LAYER_KEY = ResourceKey.createRegistryKey((ResourceLocation)HeartyMain.loc("half_heart_layer"));
    public static final DeferredRegister<HalfHeartLayer> REGISTER = DeferredRegister.create(HALF_HEART_LAYER_KEY, (String)"hearty");
    public static final Supplier<HalfHeartLayer> FROZEN = HalfHeartLayerRegistry.register("frozen", 1.0, ctx -> ctx.heartType() == HeartTypeRegistry.HEALTH.get() && ctx.player().isFullyFrozen() ? ctx.withSprite(ResourceLocation.parse((String)ctx.sprite().toString().replace("full", "frozen"))) : ctx);
    public static final Supplier<HalfHeartLayer> POISON = HalfHeartLayerRegistry.register("poison", 2.0, ctx -> ctx.heartType() == HeartTypeRegistry.HEALTH.get() && ctx.player().hasEffect(MobEffects.POISON) ? ctx.withSprite(ResourceLocation.parse((String)ctx.sprite().toString().replace("full", "poisoned"))) : ctx);
    public static final Supplier<HalfHeartLayer> WITHER = HalfHeartLayerRegistry.register("wither", 3.0, ctx -> ctx.heartType() == HeartTypeRegistry.HEALTH.get() && ctx.player().hasEffect(MobEffects.WITHER) ? ctx.withSprite(ResourceLocation.parse((String)ctx.sprite().toString().replace("full", "withered"))) : ctx);
    public static final Supplier<HalfHeartLayer> HARDCORE = HalfHeartLayerRegistry.register("hardcore", 4.0, ctx -> ctx.level().getLevelData().isHardcore() && (ctx.heartType() == HeartTypeRegistry.HEALTH.get() || ctx.heartType() == HeartTypeRegistry.ABSORPTION.get()) ? ctx.withSprite(ResourceLocation.parse((String)(String.valueOf(ctx.sprite()) + "_hardcore"))) : ctx);
    public static final Supplier<HalfHeartLayer> BLINK = HalfHeartLayerRegistry.register("blink", 5.0, ctx -> ctx.gui().healthBlinkTime > (long)ctx.gui().tickCount && (ctx.gui().healthBlinkTime - (long)ctx.gui().tickCount) / 3L % 2L == 1L ? ctx.withSprite(ResourceLocation.parse((String)(String.valueOf(ctx.sprite()) + "_blinking"))) : ctx);

    public static Supplier<HalfHeartLayer> register(String id, double priority, final Function<HalfHeartContext, HalfHeartContext> apply) {
        return REGISTER.register(id, () -> new HalfHeartLayer(HeartyMain.loc(id), priority){

            public HalfHeartContext apply(HalfHeartContext ctx) {
                return (HalfHeartContext)apply.apply(ctx);
            }
        });
    }
}

