/*
 * Decompiled with CFR 0.152.
 */
package io.github.zygzaggaming.hearty.mod;

import io.github.zygzaggaming.hearty.api.HalfHeartLayer;
import io.github.zygzaggaming.hearty.api.HeartLayer;
import io.github.zygzaggaming.hearty.api.HeartType;
import io.github.zygzaggaming.hearty.api.HeartyRegistries;
import io.github.zygzaggaming.hearty.mod.HalfHeartLayerRegistry;
import io.github.zygzaggaming.hearty.mod.HeartLayerRegistry;
import io.github.zygzaggaming.hearty.mod.HeartTypeRegistry;
import io.github.zygzaggaming.hearty.mod.HeartyConfig;
import io.github.zygzaggaming.hearty.mod.HeartyGuiLayer;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="hearty")
public class HeartyMain {
    public static final String MODID = "hearty";
    public static final Registry<HalfHeartLayer> HALF_HEART_LAYER_REGISTRY = DeferredRegister.create((ResourceKey)HeartyRegistries.HALF_HEART_LAYER_KEY, (String)"hearty").makeRegistry(builder -> {});
    public static Registry<HeartLayer> HEART_LAYER_REGISTRY = DeferredRegister.create((ResourceKey)HeartyRegistries.HEART_LAYER_KEY, (String)"hearty").makeRegistry(builder -> {});
    public static Registry<HeartType> HEART_TYPE_REGISTRY = DeferredRegister.create((ResourceKey)HeartyRegistries.HEART_TYPE_KEY, (String)"hearty").makeRegistry(builder -> {});

    public HeartyMain(IEventBus modEventBus, ModContainer modContainer) {
        if (FMLEnvironment.dist.isClient()) {
            HeartTypeRegistry.REGISTER.register(modEventBus);
            HeartLayerRegistry.REGISTER.register(modEventBus);
            HalfHeartLayerRegistry.REGISTER.register(modEventBus);
            modEventBus.addListener(evt -> {
                evt.register(HEART_TYPE_REGISTRY);
                evt.register(HEART_LAYER_REGISTRY);
                evt.register(HALF_HEART_LAYER_REGISTRY);
            });
            modEventBus.addListener(event -> event.registerAbove(VanillaGuiLayers.PLAYER_HEALTH, ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"hearty_health"), (LayeredDraw.Layer)new HeartyGuiLayer()));
            NeoForge.EVENT_BUS.addListener(event -> {
                if (event.getName().equals((Object)VanillaGuiLayers.PLAYER_HEALTH)) {
                    event.setCanceled(true);
                }
            });
            modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)HeartyConfig.SPEC);
        }
    }

    public static ResourceLocation loc(String string) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)string);
    }
}

