/*
 * Decompiled with CFR 0.152.
 */
package com.bytespacegames.autogg;

import com.bytespacegames.autogg.AutoGG;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class RegexManager {
    public static RegexManager INSTANCE;
    private final List<ServerConfig> servers = new ArrayList<ServerConfig>();

    public RegexManager() {
        INSTANCE = this;
        this.load();
    }

    public List<ServerConfig> getServers() {
        return this.servers;
    }

    public ServerConfig getConfigByIP(String ip) {
        for (ServerConfig config : this.servers) {
            if (config.ipMatch == null || !ip.matches(config.ipMatch)) continue;
            return config;
        }
        return null;
    }

    public void load() {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream("assets/autogg/regex.txt");){
            String line;
            if (stream == null) {
                AutoGG.LOGGER.error("regex.txt not found in resources/assets/autogg/");
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            ServerConfig currentServer = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith(":")) {
                    String serverName = line.substring(1).trim();
                    currentServer = new ServerConfig("", "");
                    this.servers.add(currentServer);
                    continue;
                }
                if (line.startsWith("\"prefix\"")) {
                    String prefix;
                    if (currentServer == null) continue;
                    currentServer.messagePrefix = prefix = line.split(":")[1].trim().replaceAll("^\"|\"$", "");
                    continue;
                }
                if (line.startsWith("\"criteria\"")) {
                    String criteria;
                    if (currentServer == null) continue;
                    currentServer.ipMatch = criteria = line.trim().substring(13, line.length() - 1);
                    continue;
                }
                if (!line.startsWith("\"trigger\": ") || currentServer == null) continue;
                String[] parts = line.split("\"trigger\": ", 2)[1].split(",", 2);
                int type = Integer.parseInt(parts[0]);
                String pattern = parts[1];
                currentServer.addRegex(new Regex(type, pattern));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ServerConfig {
        private String ipMatch;
        private String messagePrefix;
        private final List<Regex> regexes = new ArrayList<Regex>();

        public ServerConfig(String ipMatch, String messagePrefix) {
            this.ipMatch = ipMatch;
            this.messagePrefix = messagePrefix;
        }

        public void addRegex(Regex r) {
            this.regexes.add(r);
        }

        public List<Regex> getList() {
            return this.regexes;
        }

        public String getPrefix() {
            return this.messagePrefix;
        }
    }

    public static class Regex {
        private int type;
        private String match;

        public Regex(int type, String match) {
            this.type = type;
            this.match = match;
        }

        public int getType() {
            return this.type;
        }

        public String getMatch() {
            return this.match;
        }
    }
}

