/*
 * Decompiled with CFR 0.152.
 */
package com.bytespacegames.autogg;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import net.minecraft.class_310;

public class Settings {
    private static final String DEFAULT_MESSAGE = "gg";
    private static final double DEFAULT_DELAY = 0.0;
    public double delay;
    public String message;
    public static Settings INSTANCE;

    public Settings() {
        INSTANCE = this;
        this.load();
    }

    public void load() {
        Path path = Paths.get(class_310.method_1551().field_1697.getAbsolutePath() + "/config/spaceautogg.config", new String[0]);
        Properties props = new Properties();
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                props.load(in);
                this.message = props.getProperty("message", DEFAULT_MESSAGE);
                this.delay = Double.parseDouble(props.getProperty("delay", "0.0"));
                return;
            }
            catch (IOException | NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.delay = 0.0;
        this.message = DEFAULT_MESSAGE;
    }

    public void save() {
        new Thread(() -> {
            Path path = Paths.get(class_310.method_1551().field_1697.getAbsolutePath() + "/config/spaceautogg.config", new String[0]);
            Properties props = new Properties();
            props.setProperty("message", this.message);
            props.setProperty("delay", String.valueOf(this.delay));
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                props.store(out, "AutoGG Settings");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, "Settings-Save-Thread").start();
    }
}

