/*
 * Decompiled with CFR 0.152.
 */
package me.rickperix.strictcraft;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.rickperix.strictcraft.Main;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class CommandBlockProtector
implements Listener {
    private final Main plugin;
    private final Set<UUID> recentlyWarned = new HashSet<UUID>();
    private final Set<UUID> recentlyCounted = new HashSet<UUID>();
    private boolean blockUsage;
    private String blockedMessage;

    public CommandBlockProtector(Main plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("command-blocks");
        if (section != null) {
            this.blockUsage = section.getBoolean("block-usage", true);
            this.blockedMessage = ChatColor.RED + "You cannot place or interact with command blocks.";
        } else {
            this.blockUsage = true;
            this.blockedMessage = ChatColor.RED + "Command block protection active (default).";
        }
    }

    @EventHandler
    public void onCommandBlockInteract(PlayerInteractEvent event) {
        if (!this.plugin.getConfigManager().isEnabled() || !this.blockUsage) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (player == null || this.plugin.getConfigManager().isPlayerExcluded(player.getName())) {
            return;
        }
        if (block == null || !this.isCommandBlock(block.getType())) {
            return;
        }
        if (player.hasPermission("strictcraft.bypass")) {
            return;
        }
        event.setCancelled(true);
        this.countOnce(player);
        this.sendOnce(player);
    }

    @EventHandler
    public void onCommandBlockPlace(BlockPlaceEvent event) {
        if (!this.plugin.getConfigManager().isEnabled() || !this.blockUsage) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (player == null || this.plugin.getConfigManager().isPlayerExcluded(player.getName())) {
            return;
        }
        if (block == null || !this.isCommandBlock(block.getType())) {
            return;
        }
        if (player.hasPermission("strictcraft.bypass")) {
            return;
        }
        event.setCancelled(true);
        this.countOnce(player);
        this.sendOnce(player);
    }

    private boolean isCommandBlock(Material type) {
        return type == Material.COMMAND_BLOCK || type == Material.CHAIN_COMMAND_BLOCK || type == Material.REPEATING_COMMAND_BLOCK;
    }

    private void sendOnce(Player player) {
        UUID id = player.getUniqueId();
        if (this.recentlyWarned.add(id)) {
            player.sendMessage(this.blockedMessage);
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.recentlyWarned.remove(id), 20L);
        }
    }

    private void countOnce(Player player) {
        UUID id = player.getUniqueId();
        if (this.recentlyCounted.add(id)) {
            this.plugin.getStatsManager().incrementCommandBlockInteraction();
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.recentlyCounted.remove(id), 1L);
        }
    }
}

