/*
 * Decompiled with CFR 0.152.
 */
package me.rickperix.strictcraft;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class JoinVersionListener
implements Listener {
    private final JavaPlugin plugin;
    private final File versionFile;
    private final String currentVersion;

    public JoinVersionListener(JavaPlugin plugin) {
        this.plugin = plugin;
        this.versionFile = new File(plugin.getDataFolder(), "version.dat");
        this.currentVersion = plugin.getDescription().getVersion();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.isOp()) {
            return;
        }
        String savedVersion = null;
        if (this.versionFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(this.versionFile));){
                savedVersion = reader.readLine();
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Could not read version.dat: " + e.getMessage());
            }
        }
        if (savedVersion == null || !this.currentVersion.equals(savedVersion.trim())) {
            player.sendMessage("\u00a7a[StrictCraft] \u00a7fPlugin has been successfully installed! The version currently installed on this server is \u00a7e" + this.currentVersion);
            player.sendMessage("\u00a77Please read the \u00a76README.txt \u00a77file in the plugin folder for more informations.");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.versionFile));){
                writer.write(this.currentVersion);
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Could not write version.dat: " + e.getMessage());
            }
        }
    }
}

