/*
 * Decompiled with CFR 0.152.
 */
package me.rickperix.strictcraft;

import java.util.HashMap;
import java.util.Map;
import me.rickperix.strictcraft.Main;
import org.bukkit.configuration.file.FileConfiguration;

public class StrictStatsManager {
    private final Main plugin;
    private final Map<String, Integer> blockedCommandMap = new HashMap<String, Integer>();
    private int totalBlockedCommands = 0;
    private int blockedGamemodeChanges = 0;
    private int blockedCommandBlockInteractions = 0;

    public StrictStatsManager(Main plugin) {
        this.plugin = plugin;
    }

    public void incrementBlockedCommand(String command) {
        ++this.totalBlockedCommands;
        this.blockedCommandMap.merge(command.toLowerCase(), 1, Integer::sum);
        FileConfiguration config = this.plugin.getStatsConfig();
        config.set("total-blocked-commands", (Object)this.totalBlockedCommands);
        config.set("most-blocked-command", (Object)this.getMostBlockedCommand());
        this.plugin.saveStats();
    }

    public void incrementBlockedGamemodeChange() {
        ++this.blockedGamemodeChanges;
        FileConfiguration config = this.plugin.getStatsConfig();
        config.set("blocked-gamemode-changes", (Object)this.blockedGamemodeChanges);
        this.plugin.saveStats();
    }

    public void incrementCommandBlockInteraction() {
        ++this.blockedCommandBlockInteractions;
        FileConfiguration config = this.plugin.getStatsConfig();
        config.set("blocked-command-block-interactions", (Object)this.blockedCommandBlockInteractions);
        this.plugin.saveStats();
    }

    public int getTotalBlockedCommands() {
        return this.totalBlockedCommands;
    }

    public int getBlockedGamemodeChanges() {
        return this.blockedGamemodeChanges;
    }

    public int getBlockedCommandBlockInteractions() {
        return this.blockedCommandBlockInteractions;
    }

    public String getMostBlockedCommand() {
        return this.blockedCommandMap.entrySet().stream().max(Map.Entry.comparingByValue()).map(entry -> "/" + (String)entry.getKey() + " (" + entry.getValue() + ")").orElse("None");
    }
}

