/*
 * Decompiled with CFR 0.152.
 */
package me.rickperix.strictcraft;

import java.util.List;
import me.rickperix.strictcraft.Main;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerGameModeChangeEvent;

public class GameModeBlocker
implements Listener {
    private final Main plugin;

    public GameModeBlocker(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onGameModeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        String name = player.getName();
        if (!this.plugin.getConfigManager().isEnabled()) {
            return;
        }
        if (!this.plugin.getConfigManager().isGamemodeEnforcementEnabled()) {
            return;
        }
        if (this.plugin.getConfigManager().isPlayerExcluded(name)) {
            return;
        }
        if (player.hasPermission("strictcraft.bypass")) {
            return;
        }
        GameMode newMode = event.getNewGameMode();
        if (newMode != GameMode.CREATIVE) {
            return;
        }
        List blockedCommands = this.plugin.getConfig().getStringList("blocked-commands.list");
        if (blockedCommands == null || blockedCommands.isEmpty()) {
            return;
        }
        for (String cmd : blockedCommands) {
            String normalized = cmd.toLowerCase().trim();
            if (!normalized.contains("gamemode") || !normalized.contains("creative")) continue;
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "Creative mode is blocked by StrictCraft.");
            return;
        }
    }
}

