/*
 * Decompiled with CFR 0.152.
 */
package me.rickperix.strictcraft;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import me.rickperix.strictcraft.CommandBlockProtector;
import me.rickperix.strictcraft.CommandBlocker;
import me.rickperix.strictcraft.ConfigManager;
import me.rickperix.strictcraft.GameModeBlocker;
import me.rickperix.strictcraft.GameModeMonitor;
import me.rickperix.strictcraft.Metrics;
import me.rickperix.strictcraft.StrictCraftReloadCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Main
extends JavaPlugin {
    private static final String CURRENT_VERSION = "1.2";
    private static final String SPIGOT_ID = "127094";
    private static final int BSTATS_PLUGIN_ID = 26464;
    private static Main instance;
    private ConfigManager configManager;
    private CommandBlocker commandBlocker;
    private CommandBlockProtector commandBlockProtector;
    private GameModeMonitor gameModeMonitor;

    public void onEnable() {
        PluginCommand reloadCommand;
        instance = this;
        this.saveDefaultConfig();
        this.copyLicenseFile();
        this.configManager = new ConfigManager(this);
        this.commandBlocker = new CommandBlocker(this);
        this.commandBlockProtector = new CommandBlockProtector(this);
        this.gameModeMonitor = new GameModeMonitor(this);
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.commandBlocker, (Plugin)this);
        pm.registerEvents((Listener)this.commandBlockProtector, (Plugin)this);
        pm.registerEvents((Listener)new GameModeBlocker(this), (Plugin)this);
        if (this.configManager.isEnabled() && this.configManager.isGamemodeEnforcementEnabled()) {
            this.gameModeMonitor.start();
        }
        if ((reloadCommand = this.getCommand("strictcraftreload")) != null) {
            reloadCommand.setExecutor((CommandExecutor)new StrictCraftReloadCommand(this));
        }
        this.logBanner();
        this.checkForUpdates();
        new Metrics((Plugin)this, 26464);
    }

    public void onDisable() {
        this.gameModeMonitor.stop();
    }

    public static Main getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public CommandBlocker getCommandBlocker() {
        return this.commandBlocker;
    }

    public GameModeMonitor getGameModeMonitor() {
        return this.gameModeMonitor;
    }

    public CommandBlockProtector getCommandBlockProtector() {
        return this.commandBlockProtector;
    }

    public void rebuildConfigManager() {
        this.configManager = new ConfigManager(this);
    }

    private void copyLicenseFile() {
        InputStream resource;
        File target = new File(this.getDataFolder(), "LICENSE.txt");
        if (!target.exists() && (resource = this.getResource("LICENSE.txt")) != null) {
            this.saveResource("LICENSE.txt", false);
        }
    }

    private void logBanner() {
        this.getLogger().info(" ");
        this.getLogger().info("  _________ __         .__        __   _________                _____  __   ");
        this.getLogger().info(" /   _____//  |________|__| _____/  |_ \\_   ___ \\____________ _/ ____\\/  |_ ");
        this.getLogger().info(" \\_____  \\\\   __\\_  __ \\  |/ ___\\   __\\/    \\  \\/\\_  __ \\__  \\\\   __\\\\   __\\");
        this.getLogger().info(" /        \\|  |  |  | \\/  \\  \\___|  |  \\     \\____|  | \\/ __ \\|  |   |  |   ");
        this.getLogger().info("/_______  /|__|  |__|  |__|\\___  >__|   \\______  /|__|  (____  /__|   |__|   ");
        this.getLogger().info("        \\/                     \\/              \\/            \\/             ");
        this.getLogger().info("==============================================================================");
        this.getLogger().info("                                 By RickPerix                                 ");
        this.getLogger().info("                           Successfully Activated!!                           ");
        this.getLogger().info("==============================================================================");
        this.getLogger().info(" ");
    }

    private void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            try {
                String line;
                URL url = new URL("https://api.spiget.org/v2/resources/127094/versions/latest");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "StrictCraft/1.2");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                JSONParser parser = new JSONParser();
                JSONObject obj = (JSONObject)parser.parse(response.toString());
                String latestVersion = (String)obj.get((Object)"name");
                if (latestVersion == null || latestVersion.isEmpty()) {
                    this.getLogger().warning("Could not retrieve latest version info.");
                } else if (!CURRENT_VERSION.equals(latestVersion)) {
                    this.getLogger().warning("====================================");
                    this.getLogger().warning(" NEW UPDATE AVAILABLE!");
                    this.getLogger().warning(" Current version: 1.2");
                    this.getLogger().warning(" Latest version: " + latestVersion);
                    this.getLogger().warning(" Download: https://spigotmc.org/resources/127094");
                    this.getLogger().warning("====================================");
                } else {
                    this.getLogger().info("You're using the latest version!");
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Update check failed: " + e.getMessage());
            }
        });
    }
}

