/*
 * Decompiled with CFR 0.152.
 */
package me.rickperix.strictcraft;

import me.rickperix.strictcraft.Main;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerGameModeChangeEvent;

public class GameModeBlocker
implements Listener {
    private final Main plugin;

    public GameModeBlocker(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onGamemodeShortcut(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        GameMode newMode = event.getNewGameMode();
        if (this.isShortcutBlocked(newMode)) {
            event.setCancelled(true);
            String message = this.getBlockMessage(newMode);
            if (message != null && !message.isEmpty()) {
                player.sendMessage(message);
            }
        }
    }

    private boolean isShortcutBlocked(GameMode newMode) {
        String modeName = newMode.name().toLowerCase();
        for (String rawCommand : this.plugin.getConfig().getStringList("blocked-commands.list")) {
            String normalized = rawCommand.toLowerCase().replace("/", "").replace(":", "");
            if (!normalized.contains("gamemode") || !normalized.contains(modeName)) continue;
            return true;
        }
        return false;
    }

    private String getBlockMessage(GameMode newMode) {
        String trimmed;
        String path = "messages." + newMode.name().toLowerCase() + "-blocked";
        String configured = this.plugin.getConfig().getString(path);
        if (configured != null && !(trimmed = configured.trim()).isEmpty()) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)trimmed);
        }
        String fallback = "&cSwitching to " + newMode.name() + " mode is blocked.";
        return ChatColor.translateAlternateColorCodes((char)'&', (String)fallback);
    }
}

