/*
 * Decompiled with CFR 0.152.
 */
package me.rickperix.strictcraft;

import java.util.List;
import me.rickperix.strictcraft.Main;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class CommandBlocker
implements Listener {
    private final Main plugin;
    private List<String> blockedCommands;
    private String blockedMessage;

    public CommandBlocker(Main plugin) {
        this.plugin = plugin;
        this.loadConfigValues();
    }

    public void reload() {
        this.loadConfigValues();
    }

    private void loadConfigValues() {
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("blocked-commands");
        if (section != null) {
            this.blockedCommands = section.getStringList("list");
            this.blockedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)section.getString("blocked-message", "&cThis command is blocked by StrictCraft."));
        } else {
            this.blockedCommands = List.of();
            this.blockedMessage = String.valueOf(ChatColor.RED) + "This command is blocked by StrictCraft.";
        }
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        String message = event.getMessage().toLowerCase().trim();
        String playerName = event.getPlayer().getName();
        if (!this.plugin.getConfigManager().isEnabled()) {
            return;
        }
        if (this.plugin.getConfigManager().isPlayerExcluded(playerName)) {
            return;
        }
        if (event.getPlayer().hasPermission("strictcraft.bypass")) {
            return;
        }
        for (String cmd : this.blockedCommands) {
            if (!message.equals(cmd) && !message.startsWith(cmd + " ")) continue;
            event.setCancelled(true);
            event.getPlayer().sendMessage(this.blockedMessage);
            return;
        }
    }
}

