/*
 * Decompiled with CFR 0.152.
 */
package me.rickperix.strictcraft;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.rickperix.strictcraft.Main;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class GameModeMonitor {
    private final Main plugin;
    private BukkitTask task;
    private final Set<UUID> recentlyWarned = new HashSet<UUID>();

    public GameModeMonitor(Main plugin) {
        this.plugin = plugin;
    }

    public void start() {
        this.stop();
        if (!this.plugin.getConfigManager().isEnabled()) {
            return;
        }
        if (!this.plugin.getConfigManager().isGamemodeEnforcementEnabled()) {
            return;
        }
        int interval = this.plugin.getConfig().getInt("gamemode-enforcement.check-interval", 40);
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                String name = player.getName();
                UUID id = player.getUniqueId();
                if (this.plugin.getConfigManager().isPlayerExcluded(name) || player.hasPermission("strictcraft.bypass") || player.getGameMode() != GameMode.CREATIVE) continue;
                player.setGameMode(GameMode.SURVIVAL);
                this.plugin.getStatsManager().incrementBlockedGamemodeChange();
                if (!this.recentlyWarned.add(id)) continue;
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("messages.gamemode-enforced", "&cCreative mode is not allowed. You were switched to Survival.")));
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.recentlyWarned.remove(id), 20L);
            }
        }, 0L, (long)interval);
    }

    public void stop() {
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
    }
}

