/*
 * Decompiled with CFR 0.152.
 */
package me.rickperix.strictcraft;

import java.util.Collections;
import java.util.List;
import me.rickperix.strictcraft.Main;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class CommandBlocker
implements Listener {
    private final Main plugin;
    private List<String> blockedCommands;
    private String blockedMessage;

    public CommandBlocker(Main plugin) {
        this.plugin = plugin;
        this.loadConfigValues();
    }

    public void reload() {
        this.loadConfigValues();
    }

    private void loadConfigValues() {
        List list;
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("blocked-commands");
        this.blockedCommands = section != null && section.isSet("list") ? ((list = section.getStringList("list")) != null && !list.isEmpty() ? list : Collections.emptyList()) : Collections.emptyList();
        this.blockedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)(section != null ? section.getString("blocked-message", "&cThis command is blocked by StrictCraft.") : "&cThis command is blocked by StrictCraft."));
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (this.blockedCommands == null || this.blockedCommands.isEmpty()) {
            return;
        }
        String message = event.getMessage().toLowerCase().trim();
        String playerName = event.getPlayer().getName();
        if (!this.plugin.getConfigManager().isEnabled()) {
            return;
        }
        if (this.plugin.getConfigManager().isPlayerExcluded(playerName)) {
            return;
        }
        if (event.getPlayer().hasPermission("strictcraft.bypass")) {
            return;
        }
        for (String cmd : this.blockedCommands) {
            String normalized = cmd.toLowerCase().trim();
            if (!message.equals(normalized) && !message.startsWith(normalized + " ")) continue;
            event.setCancelled(true);
            event.getPlayer().sendMessage(this.blockedMessage);
            this.plugin.getStatsManager().incrementBlockedCommand(normalized);
            return;
        }
    }
}

