/*
 * Decompiled with CFR 0.152.
 */
package net.taylor.hoesarescythes.logic;

import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.taylor.hoesarescythes.config.ConfigManager;
import net.taylor.hoesarescythes.config.ModConfig;

public final class RadiusResolver {
    private static final Map<class_1792, Integer> VANILLA_DEFAULTS = Map.of(class_1802.field_8167, 1, class_1802.field_8431, 1, class_1802.field_8609, 2, class_1802.field_61342, 2, class_1802.field_8527, 3, class_1802.field_8303, 4, class_1802.field_22026, 4);

    private RadiusResolver() {
    }

    public static int getRadius(class_1799 stack) {
        Integer r;
        if (stack == null) {
            return 0;
        }
        ModConfig cfg = ConfigManager.get();
        for (ModConfig.HEntry e : cfg.hoes) {
            if (e.item != null && RadiusResolver.idEquals(stack.method_7909(), e.item)) {
                return RadiusResolver.clamp(e.radius);
            }
            if (e.tag == null || !e.tag.startsWith("#") || !RadiusResolver.isInItemTag(stack, e.tag.substring(1))) continue;
            return RadiusResolver.clamp(e.radius);
        }
        if (!cfg.replaceDefaultHoes && (r = VANILLA_DEFAULTS.get(stack.method_7909())) != null) {
            return r;
        }
        return 0;
    }

    private static boolean idEquals(class_1792 item, String idStr) {
        class_2960 id = class_2960.method_12829((String)idStr);
        return id != null && class_7923.field_41178.method_10221((Object)item).equals((Object)id);
    }

    private static boolean isInItemTag(class_1799 stack, String tagIdNoHash) {
        class_2960 tagId = class_2960.method_12829((String)tagIdNoHash);
        if (tagId == null) {
            return false;
        }
        class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagId);
        return stack.method_31573(key);
    }

    private static int clamp(int r) {
        return Math.max(0, Math.min(16, r));
    }
}

