/*
 * Decompiled with CFR 0.152.
 */
package com.github.breadmoirai.oneclickcrafting.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class OneClickCraftingConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("oneclickcrafting.json");
    private static final OneClickCraftingConfig INSTANCE = new OneClickCraftingConfig();
    private static final transient Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private boolean enableLeftClick = false;
    private boolean enableRightClick = true;
    private boolean alwaysOn = true;
    private boolean altHold = true;
    private boolean ctrlHold = true;
    private boolean dropEnable = true;

    public static OneClickCraftingConfig getInstance() {
        return INSTANCE;
    }

    public static void loadModConfig() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String s = Files.readString(CONFIG_PATH);
                OneClickCraftingConfig config = (OneClickCraftingConfig)GSON.fromJson(s, OneClickCraftingConfig.class);
                OneClickCraftingConfig instance = OneClickCraftingConfig.getInstance();
                instance.enableLeftClick = config.enableLeftClick;
                instance.enableRightClick = config.enableRightClick;
                instance.alwaysOn = config.alwaysOn;
                instance.altHold = config.altHold;
                instance.ctrlHold = config.ctrlHold;
                instance.dropEnable = config.dropEnable;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            OneClickCraftingConfig.saveModConfig();
        }
    }

    public static void saveModConfig() {
        System.out.println("Saving OneClickCrafting Mod Config to " + String.valueOf(CONFIG_PATH));
        try {
            String s = GSON.toJson((Object)OneClickCraftingConfig.getInstance());
            Files.writeString(CONFIG_PATH, (CharSequence)s, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isEnableLeftClick() {
        return this.enableLeftClick;
    }

    public void setEnableLeftClick(boolean enableLeftClick) {
        this.enableLeftClick = enableLeftClick;
    }

    public boolean isEnableRightClick() {
        return this.enableRightClick;
    }

    public void setEnableRightClick(boolean enableRightClick) {
        this.enableRightClick = enableRightClick;
    }

    public boolean isAlwaysOn() {
        return this.alwaysOn;
    }

    public void setAlwaysOn(boolean alwaysOn) {
        this.alwaysOn = alwaysOn;
    }

    public boolean isAltHold() {
        return this.altHold;
    }

    public void setAltHold(boolean altHold) {
        this.altHold = altHold;
    }

    public boolean isCtrlHold() {
        return this.ctrlHold;
    }

    public void setCtrlHold(boolean ctrlHold) {
        this.ctrlHold = ctrlHold;
    }

    public boolean isDropEnable() {
        return this.dropEnable;
    }

    public void setDropEnable(boolean dropEnable) {
        this.dropEnable = dropEnable;
    }
}

