/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1496;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6025;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.pixeldreamstudios.journal.config.JournalConfig;
import net.pixeldreamstudios.journal.network.UnlockMobPayload;

public class MobUnlockTracker {
    private static int tickCounter = 0;
    private static final Set<class_2960> alreadySent = new HashSet<class_2960>();
    private static final Long LAST_HIT_EXPIRY_MS = 5000L;
    private static final Map<Integer, Long> recentHits = new HashMap<Integer, Long>();
    private static final Long LAST_INTERACT_EXPIRY_MS = 5000L;
    private static final Map<Integer, Long> recentInteracts = new HashMap<Integer, Long>();

    public static void resetSentMobs() {
        alreadySent.clear();
        recentHits.clear();
        recentInteracts.clear();
    }

    public static void tick() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (player == null || world == null) {
            return;
        }
        long now = System.currentTimeMillis();
        recentHits.entrySet().removeIf(e -> now - (Long)e.getValue() > LAST_HIT_EXPIRY_MS);
        recentInteracts.entrySet().removeIf(e -> now - (Long)e.getValue() > LAST_INTERACT_EXPIRY_MS);
        if (JournalConfig.requireJournalInInventory && !MobUnlockTracker.hasJournalInInventory(player)) {
            tickCounter = 0;
            return;
        }
        switch (JournalConfig.discoveryMode) {
            case NEAR: {
                MobUnlockTracker.processNearMode(player);
                break;
            }
            case HIT: {
                break;
            }
            case KILL: {
                break;
            }
        }
    }

    private static boolean hasJournalInInventory(class_746 player) {
        return true;
    }

    private static void processNearMode(class_746 player) {
        class_638 world = player.field_17892;
        List nearby = world.method_8390(class_1309.class, new class_238(player.method_19538(), player.method_19538()).method_1014(JournalConfig.mobCheckRadius), e -> e != player && e.method_5805());
        ArrayList<class_2960> toUnlock = new ArrayList<class_2960>();
        for (class_1309 mob : nearby) {
            class_2960 id = class_7923.field_41177.method_10221((Object)mob.method_5864());
            if (alreadySent.contains(id) || JournalConfig.isBlacklisted(id)) continue;
            toUnlock.add(id);
        }
        if (toUnlock.isEmpty()) {
            tickCounter = 0;
            return;
        }
        if (++tickCounter < JournalConfig.mobCheckInterval) {
            return;
        }
        tickCounter = 0;
        for (class_2960 id : toUnlock) {
            MobUnlockTracker.sendUnlock(id);
        }
    }

    public static void onPlayerHitEntity(class_1297 target) {
        class_2960 id;
        if (!(target instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)target;
        recentHits.put(target.method_5628(), System.currentTimeMillis());
        if (JournalConfig.discoveryMode == JournalConfig.DiscoveryMode.HIT && !alreadySent.contains(id = class_7923.field_41177.method_10221((Object)living.method_5864())) && !JournalConfig.isBlacklisted(id)) {
            MobUnlockTracker.sendUnlock(id);
        }
    }

    public static void onPlayerInteractEntity(class_1297 target) {
        class_2960 id;
        if (!(target instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)target;
        recentInteracts.put(target.method_5628(), System.currentTimeMillis());
        if (JournalConfig.discoveryMode == JournalConfig.DiscoveryMode.INTERACT && !alreadySent.contains(id = class_7923.field_41177.method_10221((Object)living.method_5864())) && !JournalConfig.isBlacklisted(id)) {
            MobUnlockTracker.sendUnlock(id);
        }
    }

    public static void onEntityDied(class_1297 target) {
        class_2960 id;
        if (!(target instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)target;
        Long last = recentHits.get(target.method_5628());
        if (JournalConfig.discoveryMode == JournalConfig.DiscoveryMode.KILL && last != null && !alreadySent.contains(id = class_7923.field_41177.method_10221((Object)living.method_5864())) && !JournalConfig.isBlacklisted(id)) {
            MobUnlockTracker.sendUnlock(id);
        }
    }

    public static void onPlayerTamedEntity(class_1309 target) {
        if (!JournalConfig.enableTamedTrigger) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 local = client.field_1724;
        if (local == null) {
            return;
        }
        UUID ownerUuid = null;
        if (target instanceof class_1321) {
            class_1321 t = (class_1321)target;
            ownerUuid = t.method_6139();
        } else if (target instanceof class_1496) {
            class_1496 h = (class_1496)target;
            ownerUuid = h.method_6139();
        } else if (target instanceof class_6025) {
            class_6025 class_60252 = (class_6025)target;
        }
        if (ownerUuid == null || !ownerUuid.equals(local.method_5667())) {
            return;
        }
        class_2960 id = class_7923.field_41177.method_10221((Object)target.method_5864());
        if (!alreadySent.contains(id) && !JournalConfig.isBlacklisted(id)) {
            MobUnlockTracker.sendUnlock(id);
        }
    }

    private static void sendUnlock(class_2960 id) {
        UnlockMobPayload.sendToServer(id);
        alreadySent.add(id);
    }
}

