/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.data;

import dev.onyxstudios.cca.api.v3.component.ComponentV3;
import dev.onyxstudios.cca.api.v3.component.CopyableComponent;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.pixeldreamstudios.journal.config.JournalConfig;
import net.pixeldreamstudios.journal.network.DiscoveredMobPayload;
import net.pixeldreamstudios.journal.network.SyncJournalPayload;

public class JournalComponent
implements ComponentV3,
AutoSyncedComponent,
CopyableComponent<JournalComponent> {
    private final Map<class_2960, Long> discovered = new HashMap<class_2960, Long>();
    private class_3222 owner;
    private boolean hasReceivedJournal = false;

    public JournalComponent(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 sp;
            this.owner = sp = (class_3222)player;
        }
    }

    public boolean isServerSide() {
        return this.owner != null;
    }

    public boolean unlockMob(class_2960 id) {
        if (id == null || this.discovered.containsKey(id)) {
            return false;
        }
        long timestamp = JournalConfig.recordDiscoveryTimestamp ? this.owner.field_13995.method_30002().method_8510() : -1L;
        this.discovered.put(id, timestamp);
        if (this.isServerSide()) {
            DiscoveredMobPayload.sendToClient(this.owner, id, timestamp);
        }
        return true;
    }

    public void clearDiscovered() {
        this.discovered.clear();
    }

    public void removeBlacklistedMobs() {
        this.discovered.keySet().removeIf(JournalConfig::isBlacklisted);
    }

    public boolean removeMob(class_2960 id) {
        return this.discovered.remove(id) != null;
    }

    public boolean hasReceivedJournal() {
        return this.hasReceivedJournal;
    }

    public void setReceivedJournal(boolean received) {
        this.hasReceivedJournal = received;
    }

    public Map<class_2960, Long> getDiscovered() {
        return this.discovered;
    }

    public void readFromNbt(class_2487 tag) {
        this.discovered.clear();
        if (tag.method_10545("discoveries")) {
            class_2499 list = tag.method_10554("discoveries", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 c = list.method_10602(i);
                class_2960 id = class_2960.method_12829((String)c.method_10558("id"));
                long t = c.method_10537("time");
                if (id == null) continue;
                this.discovered.put(id, t);
            }
        }
        this.hasReceivedJournal = tag.method_10577("journal:given");
    }

    public void writeToNbt(class_2487 tag) {
        class_2499 list = new class_2499();
        for (Map.Entry<class_2960, Long> e : this.discovered.entrySet()) {
            class_2487 c = new class_2487();
            c.method_10582("id", e.getKey().toString());
            c.method_10544("time", e.getValue().longValue());
            list.add((Object)c);
        }
        tag.method_10566("discoveries", (class_2520)list);
        tag.method_10556("journal:given", this.hasReceivedJournal);
    }

    public void copyFrom(JournalComponent other) {
        this.discovered.clear();
        this.discovered.putAll(other.discovered);
        this.hasReceivedJournal = other.hasReceivedJournal;
        if (this.isServerSide()) {
            SyncJournalPayload.sendToClient(this.owner, this.discovered);
        }
    }
}

