/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.network;

import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public final class SyncFavoritesPayload {
    public static final class_2960 ID = new class_2960("journal", "sync_favorites");
    private final Set<class_2960> favoriteMobs;

    public SyncFavoritesPayload(Set<class_2960> favoriteMobs) {
        this.favoriteMobs = favoriteMobs;
    }

    public Set<class_2960> favoriteMobs() {
        return this.favoriteMobs;
    }

    public static SyncFavoritesPayload read(class_2540 buf) {
        int size = buf.method_10816();
        HashSet<class_2960> favorites = new HashSet<class_2960>(Math.max(0, size));
        for (int i = 0; i < size; ++i) {
            favorites.add(buf.method_10810());
        }
        return new SyncFavoritesPayload(favorites);
    }

    public void write(class_2540 buf) {
        buf.method_10804(this.favoriteMobs.size());
        for (class_2960 id : this.favoriteMobs) {
            buf.method_10812(id);
        }
    }

    public static void sendToClient(class_3222 player, Set<class_2960> favorites) {
        class_2540 buf = PacketByteBufs.create();
        new SyncFavoritesPayload(favorites).write(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ID, (class_2540)buf);
    }

    public static void sendToServer(Set<class_2960> favorites) {
        class_2540 buf = PacketByteBufs.create();
        new SyncFavoritesPayload(favorites).write(buf);
        ClientPlayNetworking.send((class_2960)ID, (class_2540)buf);
    }

    public static void registerS2C(S2CHandler handler) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ID, (client, netHandler, buf, responseSender) -> {
            SyncFavoritesPayload payload = SyncFavoritesPayload.read(buf);
            client.execute(() -> handler.handle(payload));
        });
    }

    public static void registerC2S(C2SHandler handler) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ID, (server, player, netHandler, buf, responseSender) -> {
            SyncFavoritesPayload payload = SyncFavoritesPayload.read(buf);
            server.execute(() -> handler.handle(player, payload));
        });
    }

    public static interface S2CHandler {
        public void handle(SyncFavoritesPayload var1);
    }

    public static interface C2SHandler {
        public void handle(class_3222 var1, SyncFavoritesPayload var2);
    }
}

