/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.util;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_69;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_83;
import net.pixeldreamstudios.journal.mixin.CombinedEntryAccessor;
import net.pixeldreamstudios.journal.mixin.ItemEntryAccessor;
import net.pixeldreamstudios.journal.mixin.LootPoolAccessor;
import net.pixeldreamstudios.journal.mixin.LootTableAccessor;
import net.pixeldreamstudios.journal.mixin.LootTableEntryAccessor;

public final class AllLootTableItems {
    private AllLootTableItems() {
    }

    public static Set<class_1792> getAllItemsFromLootTable(class_2960 key, class_3218 world) {
        class_52 table = world.method_8503().method_3857().getLootTable(key);
        HashSet<class_1792> items = new HashSet<class_1792>();
        HashSet<class_2960> visited = new HashSet<class_2960>();
        AllLootTableItems.collectItems(key, table, world, items, visited);
        return items;
    }

    private static void collectItems(class_2960 id, class_52 table, class_3218 world, Set<class_1792> collected, Set<class_2960> visited) {
        class_55[] pools;
        if (!visited.add(id)) {
            return;
        }
        for (class_55 pool : pools = ((LootTableAccessor)table).getPools()) {
            class_79[] entries;
            for (class_79 entry : entries = ((LootPoolAccessor)pool).getEntries()) {
                class_79[] children;
                if (entry instanceof class_83) {
                    class_83 lootTableEntry = (class_83)entry;
                    class_2960 childId = ((LootTableEntryAccessor)lootTableEntry).getId();
                    class_52 subTable = world.method_8503().method_3857().getLootTable(childId);
                    AllLootTableItems.collectItems(childId, subTable, world, collected, visited);
                    continue;
                }
                if (entry instanceof class_77) {
                    class_77 itemEntry = (class_77)entry;
                    class_1792 item = ((ItemEntryAccessor)itemEntry).getItem();
                    collected.add(item);
                    continue;
                }
                if (!(entry instanceof class_69)) continue;
                class_69 combined = (class_69)entry;
                for (class_79 child : children = ((CombinedEntryAccessor)combined).getChildren()) {
                    AllLootTableItems.simulateEntry(child, collected, world, visited);
                }
            }
        }
    }

    private static void simulateEntry(class_79 entry, Set<class_1792> collected, class_3218 world, Set<class_2960> visited) {
        if (entry instanceof class_77) {
            class_77 itemEntry = (class_77)entry;
            class_1792 item = ((ItemEntryAccessor)itemEntry).getItem();
            collected.add(item);
        } else if (entry instanceof class_83) {
            class_83 lootTableEntry = (class_83)entry;
            class_2960 childId = ((LootTableEntryAccessor)lootTableEntry).getId();
            class_52 subTable = world.method_8503().method_3857().getLootTable(childId);
            AllLootTableItems.collectItems(childId, subTable, world, collected, visited);
        } else if (entry instanceof class_69) {
            class_79[] children;
            class_69 combined = (class_69)entry;
            for (class_79 child : children = ((CombinedEntryAccessor)combined).getChildren()) {
                AllLootTableItems.simulateEntry(child, collected, world, visited);
            }
        }
    }
}

