/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.network;

import java.util.ArrayList;
import java.util.Map;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.pixeldreamstudios.journal.client.JournalClient;
import net.pixeldreamstudios.journal.client.JournalClientData;
import net.pixeldreamstudios.journal.client.MobUnlockTracker;
import net.pixeldreamstudios.journal.client.gui.JournalScreen;
import net.pixeldreamstudios.journal.client.gui.MobDetailsScreen;
import net.pixeldreamstudios.journal.client.toast.MobDiscoveredToast;
import net.pixeldreamstudios.journal.config.JournalConfig;
import net.pixeldreamstudios.journal.item.JournalItems;
import net.pixeldreamstudios.journal.network.ClientReadyPayload;
import net.pixeldreamstudios.journal.network.DiscoveredMobPayload;
import net.pixeldreamstudios.journal.network.DiscoveredMobToastPayload;
import net.pixeldreamstudios.journal.network.OpenJournalPayload;
import net.pixeldreamstudios.journal.network.SyncFavoritesPayload;
import net.pixeldreamstudios.journal.network.SyncJournalPayload;
import net.pixeldreamstudios.journal.network.SyncMobDropsPayload;
import net.pixeldreamstudios.journal.network.SyncMobStatsPayload;
import net.pixeldreamstudios.journal.util.MobEntityCache;

public class JournalClientNetwork {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver(SyncJournalPayload.ID, (payload, context) -> class_310.method_1551().execute(() -> {
            JournalClientData.DISCOVERED.clear();
            JournalClientData.DISCOVERED_TIME.clear();
            for (Map.Entry<class_2960, Long> e : payload.discoveries().entrySet()) {
                JournalClientData.DISCOVERED.add(e.getKey());
                JournalClientData.DISCOVERED_TIME.put(e.getKey(), e.getValue());
            }
            MobEntityCache.preload(payload.discoveries().keySet(), (class_1937)class_310.method_1551().field_1687);
            class_437 patt0$temp = class_310.method_1551().field_1755;
            if (patt0$temp instanceof JournalScreen) {
                JournalScreen screen = (JournalScreen)patt0$temp;
                screen.updateDiscoveredMobs();
            }
            MobUnlockTracker.resetSentMobs();
            if (JournalClientData.shouldOpenJournalScreen) {
                class_310.method_1551().field_1724.method_5783(class_3417.field_17481, 1.0f, 1.0f + (float)(Math.random() * 0.2 - 0.1));
                class_310.method_1551().method_1507((class_437)new JournalScreen());
                JournalClientData.shouldOpenJournalScreen = false;
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(DiscoveredMobPayload.ID, (payload, context) -> class_310.method_1551().execute(() -> {
            JournalClientData.DISCOVERED.add(payload.mobId());
            JournalClientData.DISCOVERED_TIME.put(payload.mobId(), payload.timestamp());
            class_437 patt0$temp = class_310.method_1551().field_1755;
            if (patt0$temp instanceof JournalScreen) {
                JournalScreen screen = (JournalScreen)patt0$temp;
                screen.updateDiscoveredMobs();
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(SyncMobDropsPayload.ID, (payload, context) -> class_310.method_1551().execute(() -> {
            JournalClientData.LAST_DROPS = new ArrayList<class_1799>(payload.drops().values());
            class_437 patt0$temp = class_310.method_1551().field_1755;
            if (patt0$temp instanceof MobDetailsScreen) {
                MobDetailsScreen screen = (MobDetailsScreen)patt0$temp;
                screen.rebuildWithDrops();
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(DiscoveredMobToastPayload.ID, (payload, context) -> context.client().execute(() -> {
            class_2960 mobId = payload.mobId();
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(mobId);
            MobDiscoveredToast.show(type, (class_2561)class_2561.method_43471((String)"toast.journal.mob_discovered"), (class_2561)class_2561.method_43471((String)type.method_5882()));
        }));
        ClientPlayNetworking.registerGlobalReceiver(SyncMobStatsPayload.ID, (payload, context) -> class_310.method_1551().execute(() -> {
            JournalClientData.MOB_STATS.clear();
            JournalClientData.MOB_STATS.putAll(payload.stats());
        }));
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> sender.sendPacket((class_8710)ClientReadyPayload.INSTANCE));
        ClientPlayNetworking.registerGlobalReceiver(SyncFavoritesPayload.ID, (payload, context) -> class_310.method_1551().execute(() -> {
            JournalClientData.FAVORITE_MOBS.clear();
            JournalClientData.FAVORITE_MOBS.addAll(payload.favoriteMobs());
            class_437 patt0$temp = class_310.method_1551().field_1755;
            if (patt0$temp instanceof JournalScreen) {
                JournalScreen screen = (JournalScreen)patt0$temp;
                screen.updateDiscoveredMobs();
            }
        }));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (JournalClient.openJournalKey.method_1436()) {
                if (client.field_1724 == null || client.field_1687 == null) continue;
                boolean hasJournal = client.field_1724.method_31548().method_7379(new class_1799((class_1935)JournalItems.JOURNAL_ITEM));
                boolean needsBook = JournalConfig.requireJournalInInventory;
                if (!needsBook || hasJournal) {
                    JournalClientData.shouldOpenJournalScreen = true;
                    ClientPlayNetworking.send((class_8710)OpenJournalPayload.INSTANCE);
                    continue;
                }
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cYou need to carry your Journal to open it!"), true);
            }
        });
    }
}

