/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class MarkdownParser {
    private static final Pattern BOLD = Pattern.compile("\\*\\*(.+?)\\*\\*");
    private static final Pattern ITALIC = Pattern.compile("\\*(.+?)\\*");
    private static final Pattern TITLE = Pattern.compile("## (.+)");
    private static final Pattern HOVER_TEXT = Pattern.compile("\\[(.+?)\\]\\(hover:(.*?)\\)");
    private static final Pattern INLINE_TAG = Pattern.compile("(!)?\\[(.*?)\\]\\((item|texture):([^\\s\")]+)(?:\\s+scale=([0-9.]+))?(?:\\s+\"(.*?)\")?\\)");
    private static final Map<String, String> COLOR_CODES = Map.ofEntries(Map.entry("black", "\u00a70"), Map.entry("dark_blue", "\u00a71"), Map.entry("dark_green", "\u00a72"), Map.entry("dark_aqua", "\u00a73"), Map.entry("dark_red", "\u00a74"), Map.entry("dark_purple", "\u00a75"), Map.entry("gold", "\u00a76"), Map.entry("gray", "\u00a77"), Map.entry("dark_gray", "\u00a78"), Map.entry("blue", "\u00a79"), Map.entry("green", "\u00a7a"), Map.entry("aqua", "\u00a7b"), Map.entry("red", "\u00a7c"), Map.entry("light_purple", "\u00a7d"), Map.entry("yellow", "\u00a7e"), Map.entry("white", "\u00a7f"), Map.entry("obfuscated", "\u00a7k"), Map.entry("bold", "\u00a7l"), Map.entry("strikethrough", "\u00a7m"), Map.entry("underline", "\u00a7n"), Map.entry("italic", "\u00a7o"), Map.entry("reset", "\u00a7r"), Map.entry("ofus", "\u00a7k"));

    public static boolean containsPlaceholder(List<List<ParsedLine>> lines, String placeholder) {
        for (List<ParsedLine> line : lines) {
            for (ParsedLine part : line) {
                if (!part.isText() || !part.text.getString().contains(placeholder)) continue;
                return true;
            }
        }
        return false;
    }

    public static void replacePlaceholder(List<List<ParsedLine>> lines, String placeholder, List<ParsedLine> replacement) {
        for (int i = 0; i < lines.size(); ++i) {
            List<ParsedLine> line = lines.get(i);
            for (int j = 0; j < line.size(); ++j) {
                ParsedLine part = line.get(j);
                if (!part.isText() || !part.text.getString().contains(placeholder)) continue;
                line.remove(j);
                line.addAll(j, replacement);
                return;
            }
        }
    }

    public static List<ParsedLine> parse(String line) {
        String trailing;
        ArrayList<ParsedLine> parts = new ArrayList<ParsedLine>();
        Matcher title = TITLE.matcher(line);
        if (title.matches()) {
            parts.add(new ParsedLine((class_2561)class_2561.method_43470((String)title.group(1)).method_27695(new class_124[]{class_124.field_1073, class_124.field_1067})));
            return parts;
        }
        String processed = MarkdownParser.replaceMarkdown(line);
        Matcher hoverText = HOVER_TEXT.matcher(processed);
        while (hoverText.find()) {
            String label = hoverText.group(1);
            String tooltip = hoverText.group(2);
            ParsedLine linePart = new ParsedLine((class_2561)class_2561.method_43470((String)label).method_27694(s -> s.method_10977(class_124.field_1075)));
            linePart.tooltip = class_2561.method_43470((String)tooltip);
            parts.add(linePart);
            processed = processed.replace(hoverText.group(0), "");
        }
        Matcher matcher = INLINE_TAG.matcher(processed);
        int lastEnd = 0;
        while (matcher.find()) {
            class_2960 id;
            String before;
            if (matcher.start() > lastEnd && !(before = processed.substring(lastEnd, matcher.start())).isBlank()) {
                parts.add(new ParsedLine((class_2561)class_2561.method_43470((String)before)));
            }
            boolean isBang = matcher.group(1) != null;
            String label = matcher.group(2);
            String type = matcher.group(3);
            String value = matcher.group(4);
            String scaleStr = matcher.group(5);
            String tooltipStr = matcher.group(6);
            float scale = 1.0f;
            if (scaleStr != null) {
                try {
                    scale = Float.parseFloat(scaleStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ("item".equals(type)) {
                id = class_2960.method_12829((String)value);
                if (id != null && class_7923.field_41178.method_10250(id)) {
                    class_1799 stack = new class_1799((class_1935)class_7923.field_41178.method_10223(id));
                    ParsedLine linePart = new ParsedLine(stack);
                    linePart.scale = scale;
                    if (tooltipStr != null && !tooltipStr.strip().isEmpty()) {
                        linePart.tooltip = class_2561.method_43470((String)MarkdownParser.replaceMarkdown(tooltipStr));
                        linePart.hasExplicitTooltip = true;
                    }
                    parts.add(linePart);
                } else {
                    parts.add(new ParsedLine((class_2561)class_2561.method_43470((String)("\u2753" + value)).method_27692(class_124.field_1080)));
                }
            } else if ("texture".equals(type) && (id = class_2960.method_12829((String)value)) != null) {
                ParsedLine linePart = new ParsedLine(id);
                linePart.scale = scale;
                if (tooltipStr != null && !tooltipStr.strip().isEmpty()) {
                    linePart.tooltip = class_2561.method_43470((String)MarkdownParser.replaceMarkdown(tooltipStr));
                }
                parts.add(linePart);
            }
            lastEnd = matcher.end();
        }
        if (lastEnd < processed.length() && !(trailing = processed.substring(lastEnd)).isBlank()) {
            parts.add(new ParsedLine((class_2561)class_2561.method_43470((String)trailing)));
        }
        return parts;
    }

    private static String replaceMarkdown(String input) {
        String result = BOLD.matcher(input).replaceAll("\u00a7l$1\u00a7r");
        result = ITALIC.matcher(result).replaceAll("\u00a7o$1\u00a7r");
        for (Map.Entry<String, String> entry : COLOR_CODES.entrySet()) {
            result = result.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return result;
    }

    public static class ParsedLine {
        public final class_2561 text;
        public final class_1799 item;
        public final class_2960 texture;
        public class_2561 tooltip;
        public class_2960 hoverTexture;
        public float scale = 1.0f;
        public boolean hasExplicitTooltip = false;

        public ParsedLine(class_2561 text) {
            this.text = text;
            this.item = class_1799.field_8037;
            this.texture = null;
        }

        public ParsedLine(class_1799 item) {
            this.item = item;
            this.text = null;
            this.texture = null;
        }

        public ParsedLine(class_2960 texture) {
            this.texture = texture;
            this.item = class_1799.field_8037;
            this.text = null;
        }

        public boolean isText() {
            return this.text != null;
        }

        public boolean isItem() {
            return !this.item.method_7960();
        }

        public boolean isTexture() {
            return this.texture != null && this.text == null;
        }

        public boolean hasTooltip() {
            return this.tooltip != null && !this.tooltip.getString().isBlank();
        }
    }
}

