/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.data;

import dev.onyxstudios.cca.api.v3.component.ComponentV3;
import dev.onyxstudios.cca.api.v3.component.CopyableComponent;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.pixeldreamstudios.journal.data.JournalComponents;
import net.pixeldreamstudios.journal.data.MobStat;
import net.pixeldreamstudios.journal.network.SyncMobStatsPayload;

public class MobStatTrackerComponent
implements ComponentV3,
AutoSyncedComponent,
CopyableComponent<MobStatTrackerComponent> {
    private final Map<class_2960, MobStat> stats = new HashMap<class_2960, MobStat>();
    private class_3222 owner;

    public MobStatTrackerComponent(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 sp;
            this.owner = sp = (class_3222)player;
        }
    }

    public boolean isServerSide() {
        return this.owner != null;
    }

    public MobStat get(class_2960 id) {
        return this.stats.getOrDefault(id, new MobStat(0, 0));
    }

    public void incrementKills(class_2960 id) {
        this.stats.put(id, this.get(id).incrementKills());
        if (this.isServerSide()) {
            JournalComponents.MOB_STATS.sync((Object)this.owner);
        }
    }

    public void incrementDeaths(class_2960 id) {
        this.stats.put(id, this.get(id).incrementDeaths());
        if (this.isServerSide()) {
            JournalComponents.MOB_STATS.sync((Object)this.owner);
        }
    }

    public Map<class_2960, MobStat> getAllStats() {
        return this.stats;
    }

    public void readFromNbt(class_2487 tag) {
        this.stats.clear();
        if (!tag.method_10545("mobStats")) {
            return;
        }
        class_2487 data = tag.method_10562("mobStats");
        for (String key : data.method_10541()) {
            class_2960 id = class_2960.method_12829((String)key);
            if (id == null) continue;
            class_2487 value = data.method_10562(key);
            int kills = value.method_10550("kills");
            int deaths = value.method_10550("deaths");
            this.stats.put(id, new MobStat(kills, deaths));
        }
    }

    public void writeToNbt(class_2487 tag) {
        class_2487 data = new class_2487();
        for (Map.Entry<class_2960, MobStat> entry : this.stats.entrySet()) {
            class_2487 value = new class_2487();
            value.method_10569("kills", entry.getValue().kills());
            value.method_10569("deaths", entry.getValue().deaths());
            data.method_10566(entry.getKey().toString(), (class_2520)value);
        }
        tag.method_10566("mobStats", (class_2520)data);
    }

    public void copyFrom(MobStatTrackerComponent other) {
        this.stats.clear();
        this.stats.putAll(other.stats);
        if (this.isServerSide()) {
            SyncMobStatsPayload.sendToClient(this.owner, this.getAllStats());
        }
    }
}

