/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.network;

import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.pixeldreamstudios.journal.config.JournalConfig;
import net.pixeldreamstudios.journal.data.FavoriteMobsComponent;
import net.pixeldreamstudios.journal.data.JournalComponent;
import net.pixeldreamstudios.journal.data.JournalComponents;
import net.pixeldreamstudios.journal.data.MobStatTrackerComponent;
import net.pixeldreamstudios.journal.events.MobStatEventHandler;
import net.pixeldreamstudios.journal.item.JournalItems;
import net.pixeldreamstudios.journal.network.ClientReadyPayload;
import net.pixeldreamstudios.journal.network.DiscoveredMobToastPayload;
import net.pixeldreamstudios.journal.network.OpenJournalPayload;
import net.pixeldreamstudios.journal.network.RequestMobDropsPayload;
import net.pixeldreamstudios.journal.network.SyncFavoritesPayload;
import net.pixeldreamstudios.journal.network.SyncJournalPayload;
import net.pixeldreamstudios.journal.network.SyncMobDropsPayload;
import net.pixeldreamstudios.journal.network.SyncMobStatsPayload;
import net.pixeldreamstudios.journal.network.ToggleFavoritePayload;
import net.pixeldreamstudios.journal.network.UnlockMobPayload;
import net.pixeldreamstudios.journal.util.MobLootUtil;

public class JournalNetwork {
    private static void safeSendJournalSync(class_3222 player) {
        try {
            JournalComponent journal = (JournalComponent)JournalComponents.JOURNAL.get((Object)player);
            Map<class_2960, Long> discoveries = journal.getDiscovered();
            discoveries.entrySet().removeIf(e -> e.getKey() == null || e.getValue() == null);
            SyncJournalPayload.sendToClient(player, discoveries);
        }
        catch (Exception e2) {
            player.field_13995.execute(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                JournalNetwork.safeSendJournalSync(player);
            });
        }
    }

    public static void init() {
        MobStatEventHandler.register();
        UnlockMobPayload.registerC2S((player, payload) -> {
            class_2960 id = payload.mobId();
            JournalComponent journal = (JournalComponent)JournalComponents.JOURNAL.get((Object)player);
            if (JournalConfig.isBlacklisted(id)) {
                return;
            }
            if (journal.unlockMob(id)) {
                DiscoveredMobToastPayload.sendToClient(player, id);
                JournalNetwork.safeSendJournalSync(player);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            JournalComponent journal = (JournalComponent)JournalComponents.JOURNAL.get((Object)player);
            if (!journal.hasReceivedJournal()) {
                player.method_7270(new class_1799((class_1935)JournalItems.JOURNAL_ITEM));
                journal.setReceivedJournal(true);
            }
            journal.removeBlacklistedMobs();
            FavoriteMobsComponent favorites = (FavoriteMobsComponent)JournalComponents.FAVORITES.get((Object)player);
            SyncFavoritesPayload.sendToClient(player, favorites.getFavorites());
        });
        ClientReadyPayload.registerC2S((player, payload) -> {
            JournalComponent journal = (JournalComponent)JournalComponents.JOURNAL.get((Object)player);
            journal.removeBlacklistedMobs();
            JournalNetwork.safeSendJournalSync(player);
            MobStatTrackerComponent mobStats = (MobStatTrackerComponent)JournalComponents.MOB_STATS.get((Object)player);
            SyncMobStatsPayload.sendToClient(player, mobStats.getAllStats());
        });
        OpenJournalPayload.registerC2S((player, payload) -> {
            JournalComponent comp = (JournalComponent)JournalComponents.JOURNAL.get((Object)player);
            SyncJournalPayload.sendToClient(player, comp.getDiscovered());
            MobStatTrackerComponent stats = (MobStatTrackerComponent)JournalComponents.MOB_STATS.get((Object)player);
            SyncMobStatsPayload.sendToClient(player, stats.getAllStats());
        });
        RequestMobDropsPayload.registerC2S((player, payload) -> {
            class_1297 entity;
            class_3218 world = player.method_51469();
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(payload.mobId());
            if (type != null && type.method_5896() && (entity = type.method_5883((class_1937)world)) instanceof class_1309) {
                class_1309 mob = (class_1309)entity;
                Map<class_2960, class_1799> drops = MobLootUtil.getAllPossibleDrops(mob, world);
                SyncMobDropsPayload.sendToClient(player, drops);
            }
        });
        ToggleFavoritePayload.registerC2S((player, payload) -> {
            FavoriteMobsComponent comp = (FavoriteMobsComponent)JournalComponents.FAVORITES.get((Object)player);
            comp.toggleFavorite(payload.mobId(), payload.favorited());
            SyncFavoritesPayload.sendToClient(player, comp.getFavorites());
        });
    }
}

