/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.journal.network;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public final class SyncJournalPayload {
    public static final class_2960 ID = new class_2960("journal", "sync_journal");
    private final Map<class_2960, Long> discoveries;

    public SyncJournalPayload(Map<class_2960, Long> discoveries) {
        this.discoveries = discoveries;
    }

    public Map<class_2960, Long> discoveries() {
        return this.discoveries;
    }

    public static SyncJournalPayload read(class_2540 buf) {
        int size = buf.readInt();
        HashMap<class_2960, Long> map = new HashMap<class_2960, Long>(Math.max(0, size));
        for (int i = 0; i < size; ++i) {
            class_2960 id = buf.method_10810();
            long t = buf.readLong();
            map.put(id, t);
        }
        return new SyncJournalPayload(map);
    }

    public void write(class_2540 buf) {
        buf.writeInt(this.discoveries.size());
        for (Map.Entry<class_2960, Long> e : this.discoveries.entrySet()) {
            if (e.getKey() == null) continue;
            buf.method_10812(e.getKey());
            buf.writeLong(e.getValue() == null ? -1L : e.getValue());
        }
    }

    public static void sendToClient(class_3222 player, Map<class_2960, Long> discoveries) {
        class_2540 buf = PacketByteBufs.create();
        new SyncJournalPayload(discoveries).write(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ID, (class_2540)buf);
    }

    public static void sendToServer(Map<class_2960, Long> discoveries) {
        class_2540 buf = PacketByteBufs.create();
        new SyncJournalPayload(discoveries).write(buf);
        ClientPlayNetworking.send((class_2960)ID, (class_2540)buf);
    }

    public static void registerS2C(S2CHandler handler) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ID, (client, netHandler, buf, responseSender) -> {
            SyncJournalPayload payload = SyncJournalPayload.read(buf);
            client.execute(() -> handler.handle(payload));
        });
    }

    public static void registerC2S(C2SHandler handler) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ID, (server, player, netHandler, buf, responseSender) -> {
            SyncJournalPayload payload = SyncJournalPayload.read(buf);
            server.execute(() -> handler.handle(player, payload));
        });
    }

    public static interface S2CHandler {
        public void handle(SyncJournalPayload var1);
    }

    public static interface C2SHandler {
        public void handle(class_3222 var1, SyncJournalPayload var2);
    }
}

